#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 mortalius
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Kingdom: New Lands
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251014.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='kingdom-new-lands'
GAME_NAME='Kingdom New Lands'

ARCHIVE_BASE_1_NAME='kingdom_new_lands_en_1_2_8_19096.sh'
ARCHIVE_BASE_1_MD5='3499d709e78410ef7f447c12e3c66039'
ARCHIVE_BASE_1_SIZE='450000'
ARCHIVE_BASE_1_VERSION='1.2.8-gog19096'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/kingdom_new_lands'

ARCHIVE_BASE_0_NAME='gog_kingdom_new_lands_2.6.0.8.sh'
ARCHIVE_BASE_0_MD5='0d662366f75d5da214e259d792e720eb'
ARCHIVE_BASE_0_SIZE='420000'
ARCHIVE_BASE_0_VERSION='1.2.3-gog2.6.0.8'

UNITY3D_NAME='Kingdom'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
