// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The configuration of the channel group.
type ChannelGroupListConfiguration struct {

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// This member is required.
	Arn *string

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// This member is required.
	ChannelGroupName *string

	// The date and time the channel group was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The date and time the channel group was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// Any descriptive information that you want to add to the channel group for
	// future identification purposes.
	Description *string

	noSmithyDocumentSerde
}

// The configuration of the channel.
type ChannelListConfiguration struct {

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// This member is required.
	Arn *string

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// This member is required.
	ChannelGroupName *string

	// The name that describes the channel. The name is the primary identifier for the
	// channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// This member is required.
	ChannelName *string

	// The date and time the channel was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The date and time the channel was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// Any descriptive information that you want to add to the channel for future
	// identification purposes.
	Description *string

	noSmithyDocumentSerde
}

// Create an HTTP live streaming (HLS) manifest configuration.
type CreateHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index, with an added suffix to distinguish it
	// from the manifest name. The manifestName on the HLSManifest object overrides the
	// manifestName you provided on the originEndpoint object.
	ChildManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags
	// aren't included in the manifest. The tags sync the stream to the wall clock so
	// that viewers can seek to a specific time in the playback timeline on the player.
	// ID3Timed metadata messages generate every 5 seconds whenever the content is
	// ingested. Irrespective of this parameter, if any ID3Timed metadata is in the HLS
	// input, it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int32

	// The SCTE configuration.
	ScteHls *ScteHls

	noSmithyDocumentSerde
}

// Create a low-latency HTTP live streaming (HLS) manifest configuration.
type CreateLowLatencyHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index, with an added suffix to distinguish it
	// from the manifest name. The manifestName on the HLSManifest object overrides the
	// manifestName you provided on the originEndpoint object.
	ChildManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags
	// aren't included in the manifest. The tags sync the stream to the wall clock so
	// that viewers can seek to a specific time in the playback timeline on the player.
	// ID3Timed metadata messages generate every 5 seconds whenever the content is
	// ingested. Irrespective of this parameter, if any ID3Timed metadata is in the HLS
	// input, it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int32

	// The SCTE configuration.
	ScteHls *ScteHls

	noSmithyDocumentSerde
}

// The parameters for encrypting content.
type Encryption struct {

	// The encryption method to use.
	//
	// This member is required.
	EncryptionMethod *EncryptionMethod

	// The parameters for the SPEKE key provider.
	//
	// This member is required.
	SpekeKeyProvider *SpekeKeyProvider

	// A 128-bit, 16-byte hex value represented by a 32-character string, used in
	// conjunction with the key for encrypting content. If you don't specify a value,
	// then MediaPackage creates the constant initialization vector (IV).
	ConstantInitializationVector *string

	// The frequency (in seconds) of key changes for live workflows, in which content
	// is streamed real time. The service retrieves content keys before the live
	// content begins streaming, and then retrieves them as needed over the lifetime of
	// the workflow. By default, key rotation is set to 300 seconds (5 minutes), the
	// minimum rotation interval, which is equivalent to setting it to 300. If you
	// don't enter an interval, content keys aren't rotated. The following example
	// setting causes the service to rotate keys every thirty minutes: 1800
	KeyRotationIntervalSeconds *int32

	noSmithyDocumentSerde
}

// Configure one or more content encryption keys for your endpoints that use SPEKE
// Version 2.0. The encryption contract defines which content keys are used to
// encrypt the audio and video tracks in your stream. To configure the encryption
// contract, specify which audio and video encryption presets to use.
type EncryptionContractConfiguration struct {

	// A collection of audio encryption presets. Value description:
	//   - PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in
	//   your stream.
	//   - PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio
	//   tracks and one content key to encrypt all of the multichannel audio tracks.
	//   - PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio
	//   tracks, one content key to encrypt all of the multichannel audio tracks with 3
	//   to 6 channels, and one content key to encrypt all of the multichannel audio
	//   tracks with more than 6 channels.
	//   - SHARED - Use the same content key for all of the audio and video tracks in
	//   your stream.
	//   - UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
	//
	// This member is required.
	PresetSpeke20Audio PresetSpeke20Audio

	// A collection of video encryption presets. Value description:
	//   - PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in
	//   your stream.
	//   - PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks
	//   and one content key for all HD and higher resolutions video tracks.
	//   - PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks,
	//   one content key for HD video tracks and one content key for all UHD video
	//   tracks.
	//   - PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks,
	//   one content key for HD video tracks, one content key for all UHD1 video tracks
	//   and one content key for all UHD2 video tracks.
	//   - PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks,
	//   one content key for HD1 video tracks, one content key for HD2 video tracks, one
	//   content key for all UHD1 video tracks and one content key for all UHD2 video
	//   tracks.
	//   - PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks,
	//   one content key for HD1 video tracks, one content key for HD2 video tracks and
	//   one content key for all UHD video tracks.
	//   - PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video
	//   tracks, one content key for HD2 video tracks and one content key for all UHD
	//   video tracks.
	//   - PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video
	//   tracks, one content key for HD2 video tracks, one content key for all UHD1 video
	//   tracks and one content key for all UHD2 video tracks.
	//   - SHARED - Use the same content key for all of the video and audio tracks in
	//   your stream.
	//   - UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
	//
	// This member is required.
	PresetSpeke20Video PresetSpeke20Video

	noSmithyDocumentSerde
}

// The encryption type.
type EncryptionMethod struct {

	// The encryption method to use.
	CmafEncryptionMethod CmafEncryptionMethod

	// The encryption method to use.
	TsEncryptionMethod TsEncryptionMethod

	noSmithyDocumentSerde
}

// Filter configuration includes settings for manifest filtering, start and end
// times, and time delay that apply to all of your egress requests for this
// manifest.
type FilterConfiguration struct {

	// Optionally specify the end time for all of your manifest egress requests. When
	// you include end time, note that you cannot use end time query parameters for
	// this manifest's endpoint URL.
	End *time.Time

	// Optionally specify one or more manifest filters for all of your manifest egress
	// requests. When you include a manifest filter, note that you cannot use an
	// identical manifest filter query parameter for this manifest's endpoint URL.
	ManifestFilter *string

	// Optionally specify the start time for all of your manifest egress requests.
	// When you include start time, note that you cannot use start time query
	// parameters for this manifest's endpoint URL.
	Start *time.Time

	// Optionally specify the time delay for all of your manifest egress requests.
	// Enter a value that is smaller than your endpoint's startover window. When you
	// include time delay, note that you cannot use time delay query parameters for
	// this manifest's endpoint URL.
	TimeDelaySeconds *int32

	noSmithyDocumentSerde
}

// Retrieve the HTTP live streaming (HLS) manifest configuration.
type GetHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	//
	// This member is required.
	Url *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the
	// HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	ChildManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags
	// aren't included in the manifest. The tags sync the stream to the wall clock so
	// that viewers can seek to a specific time in the playback timeline on the player.
	// ID3Timed metadata messages generate every 5 seconds whenever the content is
	// ingested. Irrespective of this parameter, if any ID3Timed metadata is in the HLS
	// input, it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int32

	// The SCTE configuration.
	ScteHls *ScteHls

	noSmithyDocumentSerde
}

// Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.
type GetLowLatencyHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	//
	// This member is required.
	Url *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the
	// HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	ChildManifestName *string

	// Filter configuration includes settings for manifest filtering, start and end
	// times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int32

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags
	// aren't included in the manifest. The tags sync the stream to the wall clock so
	// that viewers can seek to a specific time in the playback timeline on the player.
	// ID3Timed metadata messages generate every 5 seconds whenever the content is
	// ingested. Irrespective of this parameter, if any ID3Timed metadata is in the HLS
	// input, it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int32

	// The SCTE configuration.
	ScteHls *ScteHls

	noSmithyDocumentSerde
}

// The ingest domain URL where the source stream should be sent.
type IngestEndpoint struct {

	// The system-generated unique identifier for the IngestEndpoint.
	Id *string

	// The ingest domain URL where the source stream should be sent.
	Url *string

	noSmithyDocumentSerde
}

// List the HTTP live streaming (HLS) manifest configuration.
type ListHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the
	// HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	ChildManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	Url *string

	noSmithyDocumentSerde
}

// List the low-latency HTTP live streaming (HLS) manifest configuration.
type ListLowLatencyHlsManifestConfiguration struct {

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts the
	// format extension, such as .m3u8. You can't use the same manifest name if you use
	// HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	//
	// This member is required.
	ManifestName *string

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the
	// HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	ChildManifestName *string

	// The egress domain URL for stream delivery from MediaPackage.
	Url *string

	noSmithyDocumentSerde
}

// The configuration of the origin endpoint.
type OriginEndpointListConfiguration struct {

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// This member is required.
	Arn *string

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// This member is required.
	ChannelGroupName *string

	// The name that describes the channel. The name is the primary identifier for the
	// channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// This member is required.
	ChannelName *string

	// The type of container attached to this origin endpoint. A container type is a
	// file format that encapsulates one or more media streams, such as audio and
	// video, into a single file.
	//
	// This member is required.
	ContainerType ContainerType

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// This member is required.
	OriginEndpointName *string

	// The date and time the origin endpoint was created.
	CreatedAt *time.Time

	// Any descriptive information that you want to add to the origin endpoint for
	// future identification purposes.
	Description *string

	// An HTTP live streaming (HLS) manifest configuration.
	HlsManifests []ListHlsManifestConfiguration

	// A low-latency HLS manifest configuration.
	LowLatencyHlsManifests []ListLowLatencyHlsManifestConfiguration

	// The date and time the origin endpoint was modified.
	ModifiedAt *time.Time

	noSmithyDocumentSerde
}

// The SCTE configuration.
type Scte struct {

	// The SCTE-35 message types that you want to be treated as ad markers in the
	// output.
	ScteFilter []ScteFilter

	noSmithyDocumentSerde
}

// The SCTE configuration.
type ScteHls struct {

	// Ad markers indicate when ads should be inserted during playback. If you include
	// ad markers in the content stream in your upstream encoders, then you need to
	// inform MediaPackage what to do with the ad markers in the output. Choose what
	// you want MediaPackage to do with the ad markers. Value description:
	//   - DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition
	//   events in TS and CMAF manifests. If you use DATERANGE, you must set a
	//   programDateTimeIntervalSeconds value of 1 or higher. To learn more about
	//   DATERANGE, see SCTE-35 Ad Marker EXT-X-DATERANGE (http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html)
	//   .
	AdMarkerHls AdMarkerHls

	noSmithyDocumentSerde
}

// The segment configuration, including the segment name, duration, and other
// configuration values.
type Segment struct {

	// The parameters for encrypting content.
	Encryption *Encryption

	// When selected, the stream set includes an additional I-frame only stream, along
	// with the other tracks. If false, this extra stream is not included. MediaPackage
	// generates an I-frame only stream from the first rendition in the manifest. The
	// service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then
	// generates and includes an I-frames only playlist in the stream. This playlist
	// permits player functionality like fast forward and rewind.
	IncludeIframeOnlyStreams *bool

	// The SCTE configuration options in the segment settings.
	Scte *Scte

	// The duration (in seconds) of each segment. Enter a value equal to, or a
	// multiple of, the input segment duration. If the value that you enter is
	// different from the input segment duration, MediaPackage rounds segments to the
	// nearest multiple of the input segment duration.
	SegmentDurationSeconds *int32

	// The name that describes the segment. The name is the base name of the segment
	// used in all content manifests inside of the endpoint. You can't use spaces in
	// the name.
	SegmentName *string

	// By default, MediaPackage excludes all digital video broadcasting (DVB)
	// subtitles from the output. When selected, MediaPackage passes through DVB
	// subtitles into the output.
	TsIncludeDvbSubtitles *bool

	// When selected, MediaPackage bundles all audio tracks in a rendition group. All
	// other tracks in the stream can be used with any audio rendition from the group.
	TsUseAudioRenditionGroup *bool

	noSmithyDocumentSerde
}

// The parameters for the SPEKE key provider.
type SpekeKeyProvider struct {

	// The DRM solution provider you're using to protect your content during
	// distribution.
	//
	// This member is required.
	DrmSystems []DrmSystem

	// Configure one or more content encryption keys for your endpoints that use SPEKE
	// Version 2.0. The encryption contract defines which content keys are used to
	// encrypt the audio and video tracks in your stream. To configure the encryption
	// contract, specify which audio and video encryption presets to use.
	//
	// This member is required.
	EncryptionContractConfiguration *EncryptionContractConfiguration

	// The unique identifier for the content. The service sends this to the key server
	// to identify the current endpoint. How unique you make this depends on how
	// fine-grained you want access controls to be. The service does not permit you to
	// use the same ID for two simultaneous encryption processes. The resource ID is
	// also known as the content ID. The following example shows a resource ID:
	// MovieNight20171126093045
	//
	// This member is required.
	ResourceId *string

	// The ARN for the IAM role granted by the key provider that provides access to
	// the key provider API. This role must have a trust policy that allows
	// MediaPackage to assume the role, and it must have a sufficient permissions
	// policy to allow access to the specific key retrieval URL. Get this from your DRM
	// solution provider. Valid format: arn:aws:iam::{accountID}:role/{name} . The
	// following example shows a role ARN: arn:aws:iam::444455556666:role/SpekeAccess
	//
	// This member is required.
	RoleArn *string

	// The URL of the API Gateway proxy that you set up to talk to your key server.
	// The API Gateway proxy must reside in the same AWS Region as MediaPackage and
	// must start with https://. The following example shows a URL:
	// https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection
	//
	// This member is required.
	Url *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
