// Package containerregistry implements the Azure ARM Containerregistry service API version 2019-07-15-preview.
//
// Metadata API definition for the Azure Container Registry runtime
package containerregistry

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// BaseClient is the base client for Containerregistry.
type BaseClient struct {
	autorest.Client
	LoginURI string
}

// New creates an instance of the BaseClient client.
func New(loginURI string) BaseClient {
	return NewWithoutDefaults(loginURI)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(loginURI string) BaseClient {
	return BaseClient{
		Client:   autorest.NewClientWithUserAgent(UserAgent()),
		LoginURI: loginURI,
	}
}

// CreateManifest put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
// Parameters:
// name - name of the image (including the namespace)
// reference - a tag or a digest, pointing to a specific image
// payload - manifest body, can take v1 or v2 values depending on accept header
func (client BaseClient) CreateManifest(ctx context.Context, name string, reference string, payload Manifest) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateManifest")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateManifestPreparer(ctx, name, reference, payload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "CreateManifest", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateManifestSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "CreateManifest", resp, "Failure sending request")
		return
	}

	result, err = client.CreateManifestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "CreateManifest", resp, "Failure responding to request")
	}

	return
}

// CreateManifestPreparer prepares the CreateManifest request.
func (client BaseClient) CreateManifestPreparer(ctx context.Context, name string, reference string, payload Manifest) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name":      autorest.Encode("path", name),
		"reference": autorest.Encode("path", reference),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/vnd.docker.distribution.manifest.v2+json"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/v2/{name}/manifests/{reference}", pathParameters),
		autorest.WithJSON(payload))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateManifestSender sends the CreateManifest request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateManifestSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateManifestResponder handles the response to the CreateManifest request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateManifestResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAcrRepository delete the repository identified by `name`
// Parameters:
// name - name of the image (including the namespace)
func (client BaseClient) DeleteAcrRepository(ctx context.Context, name string) (result DeletedRepository, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteAcrRepository")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAcrRepositoryPreparer(ctx, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteAcrRepository", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAcrRepositorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteAcrRepository", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAcrRepositoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteAcrRepository", resp, "Failure responding to request")
	}

	return
}

// DeleteAcrRepositoryPreparer prepares the DeleteAcrRepository request.
func (client BaseClient) DeleteAcrRepositoryPreparer(ctx context.Context, name string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name": autorest.Encode("path", name),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAcrRepositorySender sends the DeleteAcrRepository request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteAcrRepositorySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteAcrRepositoryResponder handles the response to the DeleteAcrRepository request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteAcrRepositoryResponder(resp *http.Response) (result DeletedRepository, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAcrTag delete tag
// Parameters:
// name - name of the image (including the namespace)
// reference - tag or digest of the target manifest
func (client BaseClient) DeleteAcrTag(ctx context.Context, name string, reference string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteAcrTag")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAcrTagPreparer(ctx, name, reference)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteAcrTag", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAcrTagSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteAcrTag", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAcrTagResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteAcrTag", resp, "Failure responding to request")
	}

	return
}

// DeleteAcrTagPreparer prepares the DeleteAcrTag request.
func (client BaseClient) DeleteAcrTagPreparer(ctx context.Context, name string, reference string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name":      autorest.Encode("path", name),
		"reference": autorest.Encode("path", reference),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}/_tags/{reference}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAcrTagSender sends the DeleteAcrTag request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteAcrTagSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteAcrTagResponder handles the response to the DeleteAcrTag request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteAcrTagResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteManifest delete the manifest identified by `name` and `reference`. Note that a manifest can _only_ be deleted
// by `digest`.
// Parameters:
// name - name of the image (including the namespace)
// reference - a tag or a digest, pointing to a specific image
func (client BaseClient) DeleteManifest(ctx context.Context, name string, reference string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteManifest")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteManifestPreparer(ctx, name, reference)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteManifest", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteManifestSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteManifest", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteManifestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "DeleteManifest", resp, "Failure responding to request")
	}

	return
}

// DeleteManifestPreparer prepares the DeleteManifest request.
func (client BaseClient) DeleteManifestPreparer(ctx context.Context, name string, reference string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name":      autorest.Encode("path", name),
		"reference": autorest.Encode("path", reference),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/v2/{name}/manifests/{reference}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteManifestSender sends the DeleteManifest request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteManifestSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteManifestResponder handles the response to the DeleteManifest request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteManifestResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetAcrAccessToken exchange ACR Refresh token for an ACR Access Token
// Parameters:
// service - indicates the name of your Azure container registry.
// scope - which is expected to be a valid scope, and can be specified more than once for multiple scope
// requests. You obtained this from the Www-Authenticate response header from the challenge.
// refreshToken - must be a valid ACR refresh token
func (client BaseClient) GetAcrAccessToken(ctx context.Context, service string, scope string, refreshToken string) (result AccessToken, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrAccessToken")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrAccessTokenPreparer(ctx, service, scope, refreshToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrAccessToken", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrAccessTokenSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrAccessToken", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrAccessTokenResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrAccessToken", resp, "Failure responding to request")
	}

	return
}

// GetAcrAccessTokenPreparer prepares the GetAcrAccessToken request.
func (client BaseClient) GetAcrAccessTokenPreparer(ctx context.Context, service string, scope string, refreshToken string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	formDataParameters := map[string]interface{}{
		"grant_type":    "refresh_token",
		"refresh_token": refreshToken,
		"scope":         scope,
		"service":       service,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/oauth2/token"),
		autorest.WithFormData(autorest.MapToValues(formDataParameters)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrAccessTokenSender sends the GetAcrAccessToken request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrAccessTokenSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrAccessTokenResponder handles the response to the GetAcrAccessToken request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrAccessTokenResponder(resp *http.Response) (result AccessToken, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAcrAccessTokenFromLogin exchange Username, Password and Scope an ACR Access Token
// Parameters:
// service - indicates the name of your Azure container registry.
// scope - expected to be a valid scope, and can be specified more than once for multiple scope requests. You
// can obtain this from the Www-Authenticate response header from the challenge.
func (client BaseClient) GetAcrAccessTokenFromLogin(ctx context.Context, service string, scope string) (result AccessToken, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrAccessTokenFromLogin")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrAccessTokenFromLoginPreparer(ctx, service, scope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrAccessTokenFromLogin", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrAccessTokenFromLoginSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrAccessTokenFromLogin", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrAccessTokenFromLoginResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrAccessTokenFromLogin", resp, "Failure responding to request")
	}

	return
}

// GetAcrAccessTokenFromLoginPreparer prepares the GetAcrAccessTokenFromLogin request.
func (client BaseClient) GetAcrAccessTokenFromLoginPreparer(ctx context.Context, service string, scope string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	queryParameters := map[string]interface{}{
		"scope":   autorest.Encode("query", scope),
		"service": autorest.Encode("query", service),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/oauth2/token"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrAccessTokenFromLoginSender sends the GetAcrAccessTokenFromLogin request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrAccessTokenFromLoginSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrAccessTokenFromLoginResponder handles the response to the GetAcrAccessTokenFromLogin request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrAccessTokenFromLoginResponder(resp *http.Response) (result AccessToken, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAcrManifestAttributes get manifest attributes
// Parameters:
// name - name of the image (including the namespace)
// reference - a tag or a digest, pointing to a specific image
func (client BaseClient) GetAcrManifestAttributes(ctx context.Context, name string, reference string) (result AcrManifestAttributes, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrManifestAttributes")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrManifestAttributesPreparer(ctx, name, reference)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrManifestAttributes", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrManifestAttributesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrManifestAttributes", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrManifestAttributesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrManifestAttributes", resp, "Failure responding to request")
	}

	return
}

// GetAcrManifestAttributesPreparer prepares the GetAcrManifestAttributes request.
func (client BaseClient) GetAcrManifestAttributesPreparer(ctx context.Context, name string, reference string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name":      autorest.Encode("path", name),
		"reference": autorest.Encode("path", reference),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}/_manifests/{reference}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrManifestAttributesSender sends the GetAcrManifestAttributes request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrManifestAttributesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrManifestAttributesResponder handles the response to the GetAcrManifestAttributes request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrManifestAttributesResponder(resp *http.Response) (result AcrManifestAttributes, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAcrManifests list manifests of a repository
// Parameters:
// name - name of the image (including the namespace)
// last - query parameter for the last item in previous query. Result set will include values lexically after
// last.
// n - query parameter for max number of items
// orderby - orderby query parameter
func (client BaseClient) GetAcrManifests(ctx context.Context, name string, last string, n *int32, orderby string) (result AcrManifests, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrManifests")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrManifestsPreparer(ctx, name, last, n, orderby)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrManifests", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrManifestsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrManifests", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrManifestsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrManifests", resp, "Failure responding to request")
	}

	return
}

// GetAcrManifestsPreparer prepares the GetAcrManifests request.
func (client BaseClient) GetAcrManifestsPreparer(ctx context.Context, name string, last string, n *int32, orderby string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name": autorest.Encode("path", name),
	}

	queryParameters := map[string]interface{}{}
	if len(last) > 0 {
		queryParameters["last"] = autorest.Encode("query", last)
	}
	if n != nil {
		queryParameters["n"] = autorest.Encode("query", *n)
	}
	if len(orderby) > 0 {
		queryParameters["orderby"] = autorest.Encode("query", orderby)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}/_manifests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrManifestsSender sends the GetAcrManifests request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrManifestsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrManifestsResponder handles the response to the GetAcrManifests request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrManifestsResponder(resp *http.Response) (result AcrManifests, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAcrRefreshTokenFromExchange exchange AAD tokens for an ACR refresh Token
// Parameters:
// grantType - can take a value of access_token_refresh_token, or access_token, or refresh_token
// service - indicates the name of your Azure container registry.
// tenant - AAD tenant associated to the AAD credentials.
// refreshToken - AAD refresh token, mandatory when grant_type is access_token_refresh_token or refresh_token
// accessToken - AAD access token, mandatory when grant_type is access_token_refresh_token or access_token.
func (client BaseClient) GetAcrRefreshTokenFromExchange(ctx context.Context, grantType string, service string, tenant string, refreshToken string, accessToken string) (result RefreshToken, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrRefreshTokenFromExchange")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrRefreshTokenFromExchangePreparer(ctx, grantType, service, tenant, refreshToken, accessToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRefreshTokenFromExchange", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrRefreshTokenFromExchangeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRefreshTokenFromExchange", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrRefreshTokenFromExchangeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRefreshTokenFromExchange", resp, "Failure responding to request")
	}

	return
}

// GetAcrRefreshTokenFromExchangePreparer prepares the GetAcrRefreshTokenFromExchange request.
func (client BaseClient) GetAcrRefreshTokenFromExchangePreparer(ctx context.Context, grantType string, service string, tenant string, refreshToken string, accessToken string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	formDataParameters := map[string]interface{}{
		"grant_type": grantType,
		"service":    service,
	}
	if len(tenant) > 0 {
		formDataParameters["tenant"] = tenant
	}
	if len(refreshToken) > 0 {
		formDataParameters["refresh_token"] = refreshToken
	}
	if len(accessToken) > 0 {
		formDataParameters["access_token"] = accessToken
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/oauth2/exchange"),
		autorest.WithFormData(autorest.MapToValues(formDataParameters)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrRefreshTokenFromExchangeSender sends the GetAcrRefreshTokenFromExchange request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrRefreshTokenFromExchangeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrRefreshTokenFromExchangeResponder handles the response to the GetAcrRefreshTokenFromExchange request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrRefreshTokenFromExchangeResponder(resp *http.Response) (result RefreshToken, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAcrRepositories list repositories
// Parameters:
// last - query parameter for the last item in previous query. Result set will include values lexically after
// last.
// n - query parameter for max number of items
func (client BaseClient) GetAcrRepositories(ctx context.Context, last string, n *int32) (result Repositories, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrRepositories")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrRepositoriesPreparer(ctx, last, n)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRepositories", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrRepositoriesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRepositories", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrRepositoriesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRepositories", resp, "Failure responding to request")
	}

	return
}

// GetAcrRepositoriesPreparer prepares the GetAcrRepositories request.
func (client BaseClient) GetAcrRepositoriesPreparer(ctx context.Context, last string, n *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	queryParameters := map[string]interface{}{}
	if len(last) > 0 {
		queryParameters["last"] = autorest.Encode("query", last)
	}
	if n != nil {
		queryParameters["n"] = autorest.Encode("query", *n)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/acr/v1/_catalog"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrRepositoriesSender sends the GetAcrRepositories request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrRepositoriesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrRepositoriesResponder handles the response to the GetAcrRepositories request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrRepositoriesResponder(resp *http.Response) (result Repositories, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAcrRepositoryAttributes get repository attributes
// Parameters:
// name - name of the image (including the namespace)
func (client BaseClient) GetAcrRepositoryAttributes(ctx context.Context, name string) (result RepositoryAttributes, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrRepositoryAttributes")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrRepositoryAttributesPreparer(ctx, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRepositoryAttributes", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrRepositoryAttributesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRepositoryAttributes", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrRepositoryAttributesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrRepositoryAttributes", resp, "Failure responding to request")
	}

	return
}

// GetAcrRepositoryAttributesPreparer prepares the GetAcrRepositoryAttributes request.
func (client BaseClient) GetAcrRepositoryAttributesPreparer(ctx context.Context, name string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name": autorest.Encode("path", name),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrRepositoryAttributesSender sends the GetAcrRepositoryAttributes request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrRepositoryAttributesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrRepositoryAttributesResponder handles the response to the GetAcrRepositoryAttributes request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrRepositoryAttributesResponder(resp *http.Response) (result RepositoryAttributes, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAcrTagAttributes get tag attributes by tag
// Parameters:
// name - name of the image (including the namespace)
// reference - tag or digest of the target manifest
func (client BaseClient) GetAcrTagAttributes(ctx context.Context, name string, reference string) (result AcrTagAttributes, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrTagAttributes")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrTagAttributesPreparer(ctx, name, reference)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrTagAttributes", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrTagAttributesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrTagAttributes", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrTagAttributesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrTagAttributes", resp, "Failure responding to request")
	}

	return
}

// GetAcrTagAttributesPreparer prepares the GetAcrTagAttributes request.
func (client BaseClient) GetAcrTagAttributesPreparer(ctx context.Context, name string, reference string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name":      autorest.Encode("path", name),
		"reference": autorest.Encode("path", reference),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}/_tags/{reference}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrTagAttributesSender sends the GetAcrTagAttributes request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrTagAttributesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrTagAttributesResponder handles the response to the GetAcrTagAttributes request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrTagAttributesResponder(resp *http.Response) (result AcrTagAttributes, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAcrTags list tags of a repository
// Parameters:
// name - name of the image (including the namespace)
// last - query parameter for the last item in previous query. Result set will include values lexically after
// last.
// n - query parameter for max number of items
// orderby - orderby query parameter
// digest - filter by digest
func (client BaseClient) GetAcrTags(ctx context.Context, name string, last string, n *int32, orderby string, digest string) (result AcrRepositoryTags, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAcrTags")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAcrTagsPreparer(ctx, name, last, n, orderby, digest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrTags", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAcrTagsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrTags", resp, "Failure sending request")
		return
	}

	result, err = client.GetAcrTagsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetAcrTags", resp, "Failure responding to request")
	}

	return
}

// GetAcrTagsPreparer prepares the GetAcrTags request.
func (client BaseClient) GetAcrTagsPreparer(ctx context.Context, name string, last string, n *int32, orderby string, digest string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name": autorest.Encode("path", name),
	}

	queryParameters := map[string]interface{}{}
	if len(last) > 0 {
		queryParameters["last"] = autorest.Encode("query", last)
	}
	if n != nil {
		queryParameters["n"] = autorest.Encode("query", *n)
	}
	if len(orderby) > 0 {
		queryParameters["orderby"] = autorest.Encode("query", orderby)
	}
	if len(digest) > 0 {
		queryParameters["digest"] = autorest.Encode("query", digest)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}/_tags", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAcrTagsSender sends the GetAcrTags request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAcrTagsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAcrTagsResponder handles the response to the GetAcrTags request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAcrTagsResponder(resp *http.Response) (result AcrRepositoryTags, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDockerRegistryV2Support tells whether this Docker Registry instance supports Docker Registry HTTP API v2
func (client BaseClient) GetDockerRegistryV2Support(ctx context.Context) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetDockerRegistryV2Support")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDockerRegistryV2SupportPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetDockerRegistryV2Support", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDockerRegistryV2SupportSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetDockerRegistryV2Support", resp, "Failure sending request")
		return
	}

	result, err = client.GetDockerRegistryV2SupportResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetDockerRegistryV2Support", resp, "Failure responding to request")
	}

	return
}

// GetDockerRegistryV2SupportPreparer prepares the GetDockerRegistryV2Support request.
func (client BaseClient) GetDockerRegistryV2SupportPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/v2/"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDockerRegistryV2SupportSender sends the GetDockerRegistryV2Support request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetDockerRegistryV2SupportSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetDockerRegistryV2SupportResponder handles the response to the GetDockerRegistryV2Support request. The method always
// closes the http.Response Body.
func (client BaseClient) GetDockerRegistryV2SupportResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetManifest pulls the image manifest file associated with the specified name and reference. Reference may be a tag
// or a digest
// Parameters:
// name - name of the image (including the namespace)
// reference - a tag or a digest, pointing to a specific image
// accept - accept header string delimited by comma. For example,
// application/vnd.docker.distribution.manifest.v2+json
func (client BaseClient) GetManifest(ctx context.Context, name string, reference string, accept string) (result Manifest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetManifest")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetManifestPreparer(ctx, name, reference, accept)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetManifest", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetManifestSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetManifest", resp, "Failure sending request")
		return
	}

	result, err = client.GetManifestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetManifest", resp, "Failure responding to request")
	}

	return
}

// GetManifestPreparer prepares the GetManifest request.
func (client BaseClient) GetManifestPreparer(ctx context.Context, name string, reference string, accept string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name":      autorest.Encode("path", name),
		"reference": autorest.Encode("path", reference),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/v2/{name}/manifests/{reference}", pathParameters))
	if len(accept) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("accept", autorest.String(accept)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetManifestSender sends the GetManifest request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetManifestSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetManifestResponder handles the response to the GetManifest request. The method always
// closes the http.Response Body.
func (client BaseClient) GetManifestResponder(resp *http.Response) (result Manifest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRepositories list repositories
// Parameters:
// last - query parameter for the last item in previous query. Result set will include values lexically after
// last.
// n - query parameter for max number of items
func (client BaseClient) GetRepositories(ctx context.Context, last string, n *int32) (result Repositories, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetRepositories")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRepositoriesPreparer(ctx, last, n)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetRepositories", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRepositoriesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetRepositories", resp, "Failure sending request")
		return
	}

	result, err = client.GetRepositoriesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetRepositories", resp, "Failure responding to request")
	}

	return
}

// GetRepositoriesPreparer prepares the GetRepositories request.
func (client BaseClient) GetRepositoriesPreparer(ctx context.Context, last string, n *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	queryParameters := map[string]interface{}{}
	if len(last) > 0 {
		queryParameters["last"] = autorest.Encode("query", last)
	}
	if n != nil {
		queryParameters["n"] = autorest.Encode("query", *n)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/v2/_catalog"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRepositoriesSender sends the GetRepositories request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetRepositoriesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRepositoriesResponder handles the response to the GetRepositories request. The method always
// closes the http.Response Body.
func (client BaseClient) GetRepositoriesResponder(resp *http.Response) (result Repositories, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTagList fetch the tags under the repository identified by name
// Parameters:
// name - name of the image (including the namespace)
func (client BaseClient) GetTagList(ctx context.Context, name string) (result RepositoryTags, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetTagList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTagListPreparer(ctx, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetTagList", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTagListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetTagList", resp, "Failure sending request")
		return
	}

	result, err = client.GetTagListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "GetTagList", resp, "Failure responding to request")
	}

	return
}

// GetTagListPreparer prepares the GetTagList request.
func (client BaseClient) GetTagListPreparer(ctx context.Context, name string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name": autorest.Encode("path", name),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/v2/{name}/tags/list", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTagListSender sends the GetTagList request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetTagListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetTagListResponder handles the response to the GetTagList request. The method always
// closes the http.Response Body.
func (client BaseClient) GetTagListResponder(resp *http.Response) (result RepositoryTags, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateAcrManifestAttributes update attributes of a manifest
// Parameters:
// name - name of the image (including the namespace)
// reference - a tag or a digest, pointing to a specific image
// value - repository attribute value
func (client BaseClient) UpdateAcrManifestAttributes(ctx context.Context, name string, reference string, value *ChangeableAttributes) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateAcrManifestAttributes")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateAcrManifestAttributesPreparer(ctx, name, reference, value)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrManifestAttributes", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateAcrManifestAttributesSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrManifestAttributes", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateAcrManifestAttributesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrManifestAttributes", resp, "Failure responding to request")
	}

	return
}

// UpdateAcrManifestAttributesPreparer prepares the UpdateAcrManifestAttributes request.
func (client BaseClient) UpdateAcrManifestAttributesPreparer(ctx context.Context, name string, reference string, value *ChangeableAttributes) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name":      autorest.Encode("path", name),
		"reference": autorest.Encode("path", reference),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}/_manifests/{reference}", pathParameters))
	if value != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(value))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateAcrManifestAttributesSender sends the UpdateAcrManifestAttributes request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateAcrManifestAttributesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateAcrManifestAttributesResponder handles the response to the UpdateAcrManifestAttributes request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateAcrManifestAttributesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateAcrRepositoryAttributes update the attribute identified by `name` where `reference` is the name of the
// repository.
// Parameters:
// name - name of the image (including the namespace)
// value - repository attribute value
func (client BaseClient) UpdateAcrRepositoryAttributes(ctx context.Context, name string, value *ChangeableAttributes) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateAcrRepositoryAttributes")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateAcrRepositoryAttributesPreparer(ctx, name, value)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrRepositoryAttributes", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateAcrRepositoryAttributesSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrRepositoryAttributes", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateAcrRepositoryAttributesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrRepositoryAttributes", resp, "Failure responding to request")
	}

	return
}

// UpdateAcrRepositoryAttributesPreparer prepares the UpdateAcrRepositoryAttributes request.
func (client BaseClient) UpdateAcrRepositoryAttributesPreparer(ctx context.Context, name string, value *ChangeableAttributes) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name": autorest.Encode("path", name),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}", pathParameters))
	if value != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(value))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateAcrRepositoryAttributesSender sends the UpdateAcrRepositoryAttributes request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateAcrRepositoryAttributesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateAcrRepositoryAttributesResponder handles the response to the UpdateAcrRepositoryAttributes request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateAcrRepositoryAttributesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateAcrTagAttributes update tag attributes
// Parameters:
// name - name of the image (including the namespace)
// reference - tag or digest of the target manifest
// value - repository attribute value
func (client BaseClient) UpdateAcrTagAttributes(ctx context.Context, name string, reference string, value *ChangeableAttributes) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateAcrTagAttributes")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateAcrTagAttributesPreparer(ctx, name, reference, value)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrTagAttributes", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateAcrTagAttributesSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrTagAttributes", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateAcrTagAttributesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BaseClient", "UpdateAcrTagAttributes", resp, "Failure responding to request")
	}

	return
}

// UpdateAcrTagAttributesPreparer prepares the UpdateAcrTagAttributes request.
func (client BaseClient) UpdateAcrTagAttributesPreparer(ctx context.Context, name string, reference string, value *ChangeableAttributes) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	pathParameters := map[string]interface{}{
		"name":      autorest.Encode("path", name),
		"reference": autorest.Encode("path", reference),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/acr/v1/{name}/_tags/{reference}", pathParameters))
	if value != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(value))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateAcrTagAttributesSender sends the UpdateAcrTagAttributes request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateAcrTagAttributesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateAcrTagAttributesResponder handles the response to the UpdateAcrTagAttributes request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateAcrTagAttributesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
