/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QtGlobal>
#include <QStringList>
#include <QDebug>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMassCore includes
#include "MsXpS/libXpertMassCore/globals.hpp"

/////////////////////// libXpertMassGui includes


/////////////////////// Local includes


/////////////////////// Qt includes


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC MassCollection
{

  public:
  MassCollection(const QString &name);
  MassCollection(const QString &name, const QString &mass_text);
  MassCollection(const QString &name, const std::vector<double> &masses);
  MassCollection(const MassCollection &other);

  ~MassCollection();

  MassCollection &operator=(const MassCollection &other);

  void setName(const QString &name);
  const QString &getName() const;

  void setComment(const QString &comment);
  const QString &getComment() const;

  const std::vector<double> &getMassesCstRef() const;
  std::vector<double> &getMassesRef();

  double getMassAtIndex(std::size_t index) const;
  int textToMasses(const QString &text, ErrorList *error_list_p);
  QString massesToText();

  void sortAscending();
  void sortDescending();

  void addMass(double mass);

  void removeLessThan(double threshold);

  std::size_t size() const;

  bool validate(ErrorList *error_list_p) const;
  bool isValid() const;

  protected:
  QString m_name;
  QString m_comment;

  std::vector<double> m_masses;

  mutable bool m_isValid = false;
};


} // namespace libXpertMassCore
} // namespace MsXpS
