/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.tools.graphviz;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class GraphvizProperties
extends Properties {
    public static final String GRAPH_FORMATS = "graphformats";
    public static final String COLOR_LIST = "colorlist";
    public static final String GRAPHVIZ_EXECUTABLE = "graphvizexecutable";
    private static final String PROPERTIES_RESOURCE = "graphviz.properties";
    private static GraphvizProperties mInstance = null;

    protected GraphvizProperties() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_RESOURCE);
        try {
            super.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static GraphvizProperties getGraphvizProperties() {
        if (mInstance == null) {
            mInstance = new GraphvizProperties();
        }
        return mInstance;
    }

    public Vector getPropertyAsVector(String key) {
        Vector<String> propVec = null;
        String prop = this.getProperty(key);
        if (prop != null) {
            propVec = new Vector<String>();
            StringTokenizer st = null;
            if (prop.startsWith("\\")) {
                String delim = prop.substring(1, 2);
                st = new StringTokenizer(prop.substring(2), delim);
            } else {
                st = new StringTokenizer(prop);
            }
            while (st.hasMoreTokens()) {
                propVec.add(st.nextToken().trim());
            }
        }
        return propVec;
    }
}

