.\" Automatically generated by Pandoc 2.17.0.1
.\"
.TH "PROSODYCTL" "1" "2022-02-02" "" ""
.hy
.SH NAME
.PP
prosodyctl - Manage a Prosody XMPP server
.SH SYNOPSIS
.IP
.nf
\f[C]
prosodyctl command [--help]
\f[R]
.fi
.SH DESCRIPTION
.PP
prosodyctl is the control tool for the Prosody XMPP server.
It may be used to control the server daemon and manage users.
.PP
prosodyctl needs to be executed with sufficient privileges to perform
its commands.
This typically means executing prosodyctl as the root user.
If a user named \[lq]prosody\[rq] is found then prosodyctl will change
to that user before executing its commands.
.SH COMMANDS
.SS User Management
.PP
In the following commands users are identified by a Jabber ID, jid, of
the usual form: user\[at]domain.
.TP
adduser jid
Adds a user with Jabber ID, jid, to the server.
You will be prompted to enter the user\[cq]s password.
.TP
passwd jid
Changes the password of an existing user with Jabber ID, jid.
You will be prompted to enter the user\[cq]s new password.
.TP
deluser jid
Deletes an existing user with Jabber ID, jid, from the server.
.SS Daemon Management
.PP
Although prosodyctl has commands to manage the prosody daemon it is
recommended that you utilize your distributions daemon management
features if you attained Prosody through a package.
.PP
To perform daemon control commands prosodyctl needs a pidfile value
specified in \f[C]/etc/prosody/prosody.cfg.lua\f[R].
Failure to do so will cause prosodyctl to complain.
.TP
start
Starts the prosody server daemon.
If run as root prosodyctl will attempt to change to a user named
\[lq]prosody\[rq] before executing.
This operation will block for up to five seconds to wait for the server
to execute.
.TP
stop
Stops the prosody server daemon.
This operation will block for up to five seconds to wait for the server
to stop executing.
.TP
restart
Restarts the prosody server daemon.
Equivalent to running prosodyctl stop followed by prosodyctl start.
.TP
reload
Signals the prosody server daemon to reload configuration and reopen log
files.
.TP
status
Prints the current execution status of the prosody server daemon.
.SS Certificates
.PP
prosodyctl can create self-signed certificates, certificate requests and
private keys for use with Prosody.
Commands are of the form \f[C]prosodyctl cert subcommand\f[R].
Commands take a list of hosts to be included in the certificate.
.TP
\f[B]\f[CB]request hosts\f[B]\f[R]
Create a certificate request (CSR) file for submission to a certificate
authority.
Multiple hosts can be given, sub-domains are automatically included.
.TP
\f[B]\f[CB]generate hosts\f[B]\f[R]
Generate a self-signed certificate.
.TP
\f[B]\f[CB]key host [size]\f[B]\f[R]
Generate a private key of `size' bits (defaults to 2048).
Invoked automatically by `request' and `generate' if needed.
.TP
\f[B]\f[CB]config hosts\f[B]\f[R]
Produce a config file for the list of hosts.
Invoked automatically by `request' and `generate' if needed.
.TP
\f[B]\f[CB]import hosts paths\f[B]\f[R]
Copy certificates for hosts into the certificate path and reload
prosody.
.SS Debugging
.PP
prosodyctl can also show some information about the environment,
dependencies and such to aid in debugging.
.TP
\f[B]\f[CB]about\f[B]\f[R]
Shows environment, various paths used by Prosody and installed
dependencies.
.TP
\f[B]\f[CB]check [what]\f[B]\f[R]
Performs various sanity checks on the configuration, DNS setup and
configured TLS certificates.
\f[C]what\f[R] can be one of \f[C]config\f[R], \f[C]dns\f[R]
\f[C]certs\f[R], \f[C]disabled\f[R] and \f[C]connectivity\f[R] to run
only that check.
.SS Ejabberd Compatibility
.PP
ejabberd is another XMPP server which provides a comparable control
tool, ejabberdctl, to control its server\[cq]s operations.
prosodyctl implements some commands which are compatible with
ejabberdctl.
For details of how these commands work you should see ejabberdctl(8).
.IP
.nf
\f[C]
register user server password

unregister user server
\f[R]
.fi
.SH OPTIONS
.TP
\f[B]\f[CB]--config filename\f[B]\f[R]
Use the specified config file instead of the default.
.TP
\f[B]\f[CB]--root\f[B]\f[R]
Don\[cq]t drop root privileges (e.g.\ when invoked with sudo).
.TP
\f[B]\f[CB]--help\f[B]\f[R]
Display help text for the specified command.
.TP
\f[B]\f[CB]--verbose\f[B]\f[R]
Increase log level to show debug messages.
.TP
\f[B]\f[CB]--quiet\f[B]\f[R]
Reduce log level to only show errors.
.TP
\f[B]\f[CB]--silent\f[B]\f[R]
Disable logging completely, leaving only command output.
.SH FILES
.TP
\f[B]\f[CB]/etc/prosody/prosody.cfg.lua\f[B]\f[R]
The main prosody configuration file.
prosodyctl reads this to determine the process ID file of the prosody
server daemon and to determine if a host has been configured.
.SH ONLINE
.PP
More information may be found online at: <https://prosody.im/>
.SH AUTHORS
Dwayne Bent <dbb.1@liqd.org>; Kim Alvefur.
