#!/bin/bash
set -e
set +x

if ! test -d debian; then
	echo run outside of the debian directory
	exit 1
fi

echo "1. preparing debian/changelog ..."

sed '/^ --/q' debian/changelog > debian/changelog.cuda
head -n1 debian/changelog.cuda > debian/changelog.cuda.head
tail -n1 debian/changelog.cuda > debian/changelog.cuda.tail
rm debian/changelog.cuda

truncate --size 0 debian/changelog

sed -e 's/pytorch/pytorch-cuda/' debian/changelog.cuda.head >> debian/changelog
rm debian/changelog.cuda.head

echo "" >> debian/changelog
echo "  * Rebuild src:pytorch with CUDA (non-free) enabled." >> debian/changelog
echo "    Due to non-free B-D, section is changed from main to contrib." >> debian/changelog
echo "  * Automatically generated by src:pytorch :: debian/cudabuild.sh" >> debian/changelog
echo "    Please always merge the changes to the cuda variant back to" >> debian/changelog
echo "    src:pytorch, thanks." >> debian/changelog
echo "" >> debian/changelog

cat debian/changelog.cuda.tail >> debian/changelog
rm debian/changelog.cuda.tail

echo "2. switching debian/control to the cuda version ..."

ln -sf control.cuda debian/control

echo "3. Maintainer notes are shown below"

echo --------------------------------------------------------------------------
echo You can revert the changes using git checkout
echo --------------------------------------------------------------------------
echo Copy the source package of src:pytorch as the source package of
echo src:pytorch-cuda if sbuild cannot find it. PLS use the identical source.
echo --------------------------------------------------------------------------
