/*
Copyright (c) 2003, Dinesh Nadarajah
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation and/or 
      other materials provided with the distribution.
    * Neither the name of the author nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED 
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "tavpim-tsc.h"

static const GtkIMContextInfo tavp_tsc_xim_info = { 
   "tamilvp-tsc",	    /* ID */
   N_("TamilVP (TSCII)"),   /* Human readable name */
   "gtk+",		    /* Translation domain */
   "",		    /* Dir for bindtextdomain (not strictly needed for "gtk+") */
   ""		            /* Languages for which this module is the default */
};

gint language = ENGLISH;
gint last_sent_keysym = 0;
guint32 last_sent_unicode = 0;
guint32 last_sent_base = 0;
guint32 last_sent_modi = 0;

static const GtkIMContextInfo *info_list[] = {
  &tavp_tsc_xim_info
};

GType type_tavp_tsc = 0;

//-----------------------------------------------------------
void im_module_init (GTypeModule *type_module)
{
  gtk_im_context_tavp_tsc_xim_register_type (type_module);
}

//-----------------------------------------------------------
void im_module_exit (void)
{
  gtk_im_context_tavp_tsc_xim_shutdown ();
}

//-----------------------------------------------------------
void im_module_list (const GtkIMContextInfo ***contexts, int *n_contexts)
{
  *contexts = info_list;
  *n_contexts = G_N_ELEMENTS (info_list);
}

//-----------------------------------------------------------
GtkIMContext *im_module_create (const gchar *context_id)
{
  if (strcmp (context_id, "tamilvp-tsc") == 0)
     return GTK_IM_CONTEXT(g_object_new (type_tavp_tsc, NULL));
  else
     return NULL;
}

//-----------------------------------------------------------
void gtk_im_context_tavp_tsc_xim_shutdown (void)
{
}

//------------------------------------------------------------
void gtk_im_context_tavp_tsc_xim_register_type (GTypeModule *type_module)
{
  static const GTypeInfo im_context_tavp_tsc_xim_info =
  {
    sizeof (GtkIMContextClass),
    (GBaseInitFunc) NULL,
    (GBaseFinalizeFunc) NULL,
    (GClassInitFunc) gtk_im_context_tavp_tsc_xim_class_init,
    NULL,           /* class_finalize */    
    NULL,           /* class_data */
    sizeof (GtkIMContext),
    0,
    (GtkObjectInitFunc) gtk_im_context_tavp_tsc_xim_init,
  };

  type_tavp_tsc = 
    g_type_module_register_type (type_module,
				 GTK_TYPE_IM_CONTEXT,
				 "GtkIMContextTAVPTSC",
				 &im_context_tavp_tsc_xim_info, 0);
}

//------------------------------------------------------------
void gtk_im_context_tavp_tsc_xim_class_init (GtkIMContextClass *class)
{
  GtkIMContextClass *im_context_class = GTK_IM_CONTEXT_CLASS (class);

  //GObjectClass *gobject_class = G_OBJECT_CLASS (class);

  //parent_class = g_type_class_peek_parent (class);

  //im_context_class->set_client_window = gtk_im_context_xim_set_client_window;
  im_context_class->filter_keypress = gtk_im_context_tavp_tsc_xim_filter_keypress;
  //im_context_class->reset = gtk_im_context_xim_reset;
  //im_context_class->get_preedit_string = gtk_im_context_xim_get_preedit_string;
  //im_context_class->focus_in = gtk_im_context_xim_focus_in;
  //im_context_class->focus_out = gtk_im_context_xim_focus_out;
  //im_context_class->set_cursor_location = gtk_im_context_xim_set_cursor_location;
  //im_context_class->set_use_preedit = gtk_im_context_xim_set_use_preedit;
  //gobject_class->finalize = gtk_im_context_xim_finalize;
}

//------------------------------------------------------------
void gtk_im_context_tavp_tsc_xim_init (GtkIMContext *im_context_xim)
{
  //im_context_xim->use_preedit = FALSE;
  gtk_im_context_set_use_preedit(im_context_xim, FALSE);
}

//------------------------------------------------------------
gboolean gtk_im_context_tavp_tsc_xim_filter_keypress (GtkIMContext *context,
				                    GdkEventKey  *event)
{
   if (event->type == GDK_KEY_PRESS) {

      if (event->keyval == GDK_BackSpace)
         set_state(0, 0);        

      if ((event->state & GDK_SHIFT_MASK) &&
         (event->keyval == GDK_Shift_L || event->keyval == GDK_Shift_R)) {
             // switch language codes
             language = !language;
             set_state(0, 0);
             return TRUE;
      }

      else if (language == TAMIL &&
               event->keyval >= GDK_A && event->keyval <= GDK_z) {
                  return process_tscii_tamilvp(context, event);
      }

      else {
             guint32 u;
	     guchar utf8[16];

             set_state(event->keyval, 0);
	     u = gdk_keyval_to_unicode(event->keyval);
	     if (u == 0) {
		 return FALSE;
	     }
	     utf8[g_unichar_to_utf8(u, utf8)] = '\0';
             g_signal_emit_by_name(context, "commit", utf8);
             last_sent_keysym = event->keyval;
             last_sent_unicode = u;
             return TRUE;
      }

   }
   
   return FALSE;
}

//----------------------------------------------------------------
void send_1_unicode_value(GtkIMContext *context, guint32 u1) {

   guchar utf8[16]; 
   
   utf8[g_unichar_to_utf8(u1, utf8)] = '\0';

   g_signal_emit_by_name(context, "commit", utf8);        
}

//----------------------------------------------------------------
void send_2_unicode_value(GtkIMContext *context, guint32 u1, guint32 u2) {

   guchar utf8[16]; 

   utf8[g_unichar_to_utf8(u1, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);  
   utf8[g_unichar_to_utf8(u2, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);        
}

//----------------------------------------------------------------
void send_3_unicode_value(GtkIMContext *context, guint32 u1, guint32 u2, guint32 u3) {

   guchar utf8[16]; 

   utf8[g_unichar_to_utf8(u1, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);  
   utf8[g_unichar_to_utf8(u2, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);
   utf8[g_unichar_to_utf8(u3, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);        
}

//----------------------------------------------------------------
gboolean process_tscii_tamilvp(GtkIMContext *context, GdkEventKey *event) {

   guint32 u;
   
   switch (event->keyval) {

      case GDK_a:
         if (is_last_base_meyi() && !last_sent_modi) {
            send_1_unicode_value(context, 0xa1);
            set_state(last_sent_base, 0xa1);
         }
         else if (last_sent_base == 0xab) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xac);
            set_state(0xac, 0);
         }
         else {
            send_1_unicode_value(context, 0xab);
            set_state(0xab, 0);
         }
         break;
         
      case GDK_A:
         if (is_last_base_meyi() && !last_sent_modi) {
            send_1_unicode_value(context, 0xa1);
            set_state(last_sent_base, 0xa1);
         }         
         else {
            send_1_unicode_value(context, 0xac);
            set_state(0xac, 0);
         }
         break;
         
      case GDK_i:
         if (is_last_base_meyi() && !last_sent_modi) {
            if (last_sent_base == 0xbc) {
               gtk_im_context_delete_surrounding (context, -1, 1);
               send_1_unicode_value(context, 0xca);
            }
            else 
               send_1_unicode_value(context, 0xa2);
            set_state(last_sent_base, 0xa2);
         }
         else if (is_last_base_meyi() && last_sent_modi == 0xa2) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            if (last_sent_base == 0xbc)               
               send_1_unicode_value(context, 0xcb);
            else 
               send_1_unicode_value(context, 0xa3);
            set_state(last_sent_base, 0xa3);
         }
         else if (is_last_base_meyi() && last_sent_modi == 0xa1) {
            gtk_im_context_delete_surrounding (context, -2, 2);
            send_2_unicode_value(context, 0xa8, last_sent_base);
            set_state(last_sent_base, 0xa8);
         }
         else if (last_sent_base == 0xad) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xae);
            set_state(0xae, 0);
         }
         else if (last_sent_base == 0xab) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb3);
            set_state(0xb3, 0);
         }
         else {
            send_1_unicode_value(context, 0xad);
            set_state(0xad, 0);
         }
         break;
         
      case GDK_I:
         if (is_last_base_meyi() && !last_sent_modi) {
            if (last_sent_base == 0xbc) {
               gtk_im_context_delete_surrounding (context, -1, 1);
               send_1_unicode_value(context, 0xcb);
            }
            else            
               send_1_unicode_value(context, 0xa3);
            set_state(last_sent_base, 0xa3);
         }         
         else {
            send_1_unicode_value(context, 0xae);
            set_state(0xae, 0);
         }
         break;   

      case GDK_e:
         if (is_last_base_meyi() && !last_sent_modi) {
            gtk_im_context_delete_surrounding (context, -1, 1);            
            send_2_unicode_value(context, 0xa6, last_sent_base);
            set_state(last_sent_base, 0xa6);
         }
         else if (is_last_base_meyi() && last_sent_modi == 0xa6) {
            gtk_im_context_delete_surrounding (context, -2, 2);
            send_2_unicode_value(context, 0xa7, last_sent_base);
            set_state(last_sent_base, 0xa7);
         }
         else if (last_sent_base == 0xb1) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb2);
            set_state(0xb2, 0);
         }
         else {
            send_1_unicode_value(context, 0xb1);
            set_state(0xb1, 0);
         }
         break;
         
      case GDK_E:
         if (is_last_base_meyi() && !last_sent_modi) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_2_unicode_value(context, 0xa7, last_sent_base);
            set_state(last_sent_base, 0xa7);
         }         
         else {
            send_1_unicode_value(context, 0xb2);
            set_state(0xb2, 0);
         }
         break;   

      case GDK_o:
         if (is_last_base_meyi() && !last_sent_modi) {
            gtk_im_context_delete_surrounding (context, -1, 1);            
            send_3_unicode_value(context, 0xa6, last_sent_base, 0xa1);
            set_state(last_sent_base, M_O);
         }
         else if (is_last_base_meyi() && last_sent_modi == M_O) {
            gtk_im_context_delete_surrounding (context, -3, 3);
            send_3_unicode_value(context, 0xa7, last_sent_base, 0xa1);
            set_state(last_sent_base, M_OO);
         }
         else if (last_sent_base == 0xb4) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb5);
            set_state(0xb5, 0);
         }
         else {
            send_1_unicode_value(context, 0xb4);
            set_state(0xb4, 0);
         }
         break;
         
      case GDK_O:
         if (is_last_base_meyi() && !last_sent_modi) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_3_unicode_value(context, 0xa7, last_sent_base, 0xa1);
            set_state(last_sent_base, M_OO);
         }         
         else {
            send_1_unicode_value(context, 0xb5);
            set_state(0xb5, 0);
         }
         break;

      case GDK_u:
         if (is_last_base_meyi() && !last_sent_modi) {            
            send_u(context);
            set_state(last_sent_base, 0xa4);
         }
         else if (is_last_base_meyi() && last_sent_modi == 0xa1) {
            gtk_im_context_delete_surrounding (context, -2, 2);
            send_3_unicode_value(context, 0xa6, last_sent_base, 0xaa);
            set_state(last_sent_base, 0xaa);   
         }         
         else if (is_last_base_meyi() && last_sent_modi == 0xa4) {
            send_uu(context);
            set_state(last_sent_base, 0xa5);
         }
         else if (last_sent_base == 0xab) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb6);
            set_state(0xb6, 0);
         }         
         else if (last_sent_base == 0xaf) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb0);
            set_state(0xb0, 0);
         }
         else {
            send_1_unicode_value(context, 0xaf);
            set_state(0xaf, 0);
         }
         break;
         
      case GDK_U:
         if (is_last_base_meyi() && !last_sent_modi) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_3_unicode_value(context, 0xa7, last_sent_base, 0xa1);
            set_state(last_sent_base, M_OO);
         }         
         else {
            send_1_unicode_value(context, 0xb0);
            set_state(0xb0, 0);
         }
         break;

      case GDK_w:
         if (is_last_base_meyi() && !last_sent_modi) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_2_unicode_value(context, 0xa8, last_sent_base);
            set_state(last_sent_base, 0xa8);
         }         
         else {
            send_1_unicode_value(context, 0xb3);
            set_state(0xb3, 0);
         }
         break;
         
      case GDK_q:
         if (is_last_base_meyi() && !last_sent_modi) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_pulli(context);
            set_state(last_sent_base, M_PUL);
         }
         else {
            send_1_unicode_value(context, 0xb7);
            set_state(0xb7, 0);
         }
         break;

      case GDK_Q:
         if (is_last_base_meyi() && !last_sent_modi) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_3_unicode_value(context, 0xa6, last_sent_base, 0xaa);
            set_state(last_sent_base, 0xaa);
         }         
         else {
            send_1_unicode_value(context, 0xb6);
            set_state(0xb6, 0);
         }
         break;
                  
      case GDK_k:
         send_1_unicode_value(context, 0xb8);
         set_state(0xb8, 0);
         break;

      case GDK_g:
         if (last_sent_base == 0xc9 && last_sent_modi == 0)
            gtk_im_context_delete_surrounding (context, -1, 1);
            
         send_1_unicode_value(context, 0xb9);
         set_state(0xb9, 0);
         break;

      case GDK_c:
         send_1_unicode_value(context, 0xba);
         set_state(0xba, 0);
         break;
         
      case GDK_C:
         send_1_unicode_value(context, 0xbb);
         set_state(0xbb, 0);
         break;
         
      case GDK_t:
         send_1_unicode_value(context, 0xbc);
         set_state(0xbc, 0);
         break;         

      case GDK_N:
         send_1_unicode_value(context, 0xbd);
         set_state(0xbd, 0);
         break; 
         
      case GDK_d:
         send_1_unicode_value(context, 0xbe);
         set_state(0xbe, 0);
         break;
         
      case GDK_b:
         send_1_unicode_value(context, 0xbf);
         set_state(0xbf, 0);
         break;                  

      case GDK_p:
         send_1_unicode_value(context, 0xc0);
         set_state(0xc0, 0);
         break;
         
      case GDK_m:
         send_1_unicode_value(context, 0xc1);
         set_state(0xc1, 0);
         break;         

      case GDK_y:
         send_1_unicode_value(context, 0xc2);
         set_state(0xc2, 0);
         break; 
         
      case GDK_r:
         if (last_sent_base == 0x85 && last_sent_modi == 0) {
            gtk_im_context_delete_surrounding (context, -1, 1);      
            send_1_unicode_value(context, 0x82);
            set_state(0x82, 0);
         }
         else {      
            send_1_unicode_value(context, 0xc3);
            set_state(0xc3, 0);
         }
         break;
         
      case GDK_l:
         send_1_unicode_value(context, 0xc4);
         set_state(0xc4, 0);
         break; 
         
      case GDK_v:
         send_1_unicode_value(context, 0xc5);
         set_state(0xc5, 0);
         break;         

      case GDK_z:
         send_1_unicode_value(context, 0xc6);
         set_state(0xc6, 0);
         break; 
         
      case GDK_L:
         send_1_unicode_value(context, 0xc7);
         set_state(0xc7, 0);
         break;
         
      case GDK_R:
         send_1_unicode_value(context, 0xc8);
         set_state(0xc8, 0);
         break;          
         
      case GDK_n:
         send_1_unicode_value(context, 0xc9);
         set_state(0xc9, 0);
         break;
         
      case GDK_X:
         send_1_unicode_value(context, 0x82);
         set_state(0x82, 0);
         break; 
         
      case GDK_j:
         if (last_sent_base == 0xc9 && last_sent_modi == 0) {
            gtk_im_context_delete_surrounding (context, -1, 1);      
            send_1_unicode_value(context, 0xbb);
            set_state(0xbb, 0);
         }
         else {      
            send_1_unicode_value(context, 0x83);
            set_state(0x83, 0);
         }
         break;         

      case GDK_S:
         send_1_unicode_value(context, 0x84);
         set_state(0x84, 0);
         break; 
         
      case GDK_s:
         send_1_unicode_value(context, 0x85);
         set_state(0x85, 0);
         break;
         
      case GDK_h:
         if (last_sent_base == 0x85 && last_sent_modi == 0) {
            gtk_im_context_delete_surrounding (context, -1, 1);      
            send_1_unicode_value(context, 0x84);
            set_state(0x84, 0);
         }
         else if (last_sent_base == 0xbc && last_sent_modi == 0) {
            gtk_im_context_delete_surrounding (context, -1, 1);      
            send_1_unicode_value(context, 0xbe);
            set_state(0xbe, 0);
         }
         else {
            send_1_unicode_value(context, 0x86);
            set_state(0x86, 0);
         }
         break;          
         
      case GDK_x:
         send_1_unicode_value(context, 0x87);
         set_state(0x87, 0);
         break;         

      default:

         u = gdk_keyval_to_unicode(event->keyval);
         if (u == 0) {
            return FALSE;
         }
         send_1_unicode_value(context, u);
         last_sent_keysym = event->keyval;
         last_sent_unicode = u;
         set_state(event->keyval, 0);
         break;
   }
   
   return TRUE;
}

void set_state(guint32 base, guint32 modi) {
   last_sent_base = base;
   last_sent_modi = modi;
}

gboolean is_last_base_meyi(void) {
   if ((last_sent_base >= 0xb8 && last_sent_base <= 0xc9) ||
       (last_sent_base >= 0x83 && last_sent_base <= 0x87)) {
          return TRUE;
   }
   else
      return FALSE;
}

void send_pulli(GtkIMContext *context) {
   if (last_sent_base >= 0x83 && last_sent_base <= 0x87) 
      send_1_unicode_value(context, (last_sent_base+5));
   else 
      send_1_unicode_value(context, (last_sent_base+52));
      
   return;
}

void send_u(GtkIMContext *context) {
   if (last_sent_base >= 0x83 && last_sent_base <= 0x87) 
      send_1_unicode_value(context, 0xa4);
   else if (last_sent_base == 0xb9) {
      gtk_im_context_delete_surrounding (context, -1, 1);       
      send_1_unicode_value(context, 0x99);
   }
   else if (last_sent_base == 0xbb) {
      gtk_im_context_delete_surrounding (context, -1, 1);       
      send_1_unicode_value(context, 0x9a);
   }   
   else if (last_sent_base == 0xb8) {
      gtk_im_context_delete_surrounding (context, -1, 1);       
      send_1_unicode_value(context, 0xcc);
   }
   else if (last_sent_base == 0xba) {
      gtk_im_context_delete_surrounding (context, -1, 1);       
      send_1_unicode_value(context, 0xcd);
   }
   else {
      gtk_im_context_delete_surrounding (context, -1, 1);
      send_1_unicode_value(context, (last_sent_base+18));
   }
        
   return;
}

void send_uu(GtkIMContext *context) {
   if (last_sent_modi == 0xa4)
      gtk_im_context_delete_surrounding (context, -1, 1);

   if (last_sent_base >= 0x83 && last_sent_base <= 0x87) 
      send_1_unicode_value(context, 0xa5);
   else if (last_sent_base == 0xb9) {       
      send_1_unicode_value(context, 0x9b);
   }
   else if (last_sent_base == 0xbb) {       
      send_1_unicode_value(context, 0x9c);
   }
   else if (last_sent_base == 0xb8) {       
      send_1_unicode_value(context, 0xdc);
   }
   else if (last_sent_base == 0xba) {       
      send_1_unicode_value(context, 0xdd);
   }
   else {
      send_1_unicode_value(context, (last_sent_base+34));
   }   
      
   return;
}


