/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef KeypressCommand_h
#define KeypressCommand_h

#include "CharacterRange.h"
#include "CompositionHighlight.h"
#include "CompositionUnderline.h"
#include <wtf/ASCIICType.h>
#include <wtf/Assertions.h>
#include <wtf/text/WTFString.h>

#if PLATFORM(COCOA)

namespace WebCore {

struct KeypressCommand {
    KeypressCommand() { }

    explicit KeypressCommand(const String& commandName)
        : commandName(commandName)
    {
        ASSERT(isASCIILower(commandName[0U]));
    }

    KeypressCommand(const String& commandName, const String& text)
        : commandName(commandName)
        , text(text)
    {
        ASSERT(commandName == "insertText:"_s || text.isEmpty());
    }

    KeypressCommand(const String& commandName, const String& text, Vector<CompositionUnderline>&& underlines, Vector<CompositionHighlight>&& highlights, const CharacterRange& selectedRange, const CharacterRange& replacementRange)
        : commandName(commandName)
        , text(text)
        , underlines(WTFMove(underlines))
        , highlights(WTFMove(highlights))
        , selectedRange(selectedRange)
        , replacementRange(replacementRange)
    {
        ASSERT(commandName == "setMarkedText:"_s || (underlines.isEmpty() && highlights.isEmpty()));
    }

    String commandName; // Actually, a selector name - it may have a trailing colon, and a name that can be different from an editor command name.
    String text;
    Vector<CompositionUnderline> underlines;
    Vector<CompositionHighlight> highlights;
    CharacterRange selectedRange;
    CharacterRange replacementRange;
};

} // namespace WebCore

#endif

#endif // KeypressCommand_h
