
package ONVIF::Device::Elements::SetRelayOutputState;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' }

__PACKAGE__->__set_name('SetRelayOutputState');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %RelayOutputToken_of :ATTR(:get<RelayOutputToken>);
my %LogicalState_of :ATTR(:get<LogicalState>);

__PACKAGE__->_factory(
    [ qw(        RelayOutputToken
        LogicalState

    ) ],
    {
        'RelayOutputToken' => \%RelayOutputToken_of,
        'LogicalState' => \%LogicalState_of,
    },
    {
        'RelayOutputToken' => 'ONVIF::Device::Types::ReferenceToken',
        'LogicalState' => 'ONVIF::Device::Types::RelayLogicalState',
    },
    {

        'RelayOutputToken' => 'RelayOutputToken',
        'LogicalState' => 'LogicalState',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Device::Elements::SetRelayOutputState

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetRelayOutputState from the namespace http://www.onvif.org/ver10/device/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * RelayOutputToken

 $element->set_RelayOutputToken($data);
 $element->get_RelayOutputToken();




=item * LogicalState

 $element->set_LogicalState($data);
 $element->get_LogicalState();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::SetRelayOutputState->new($data);

Constructor. The following data structure may be passed to new():

 {
   RelayOutputToken => $some_value, # ReferenceToken
   LogicalState => $some_value, # RelayLogicalState
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

