BEGIN {
	print "#ifndef _ASM_IA64_OFFSETS_H"
	print "#define _ASM_IA64_OFFSETS_H"
	print "/*"
	print " * DO NOT MODIFY"
	print " *"
	print " * This file was generated by arch/ia64/tools/print_offsets.awk."
	print " *"
	print " */"
	#
	# This is a cheesy hack.  Make sure that
	# PF_PTRACED == 1<<PF_PTRACED_BIT.
	#
	print "#define PF_PTRACED_BIT		4"
}

# look for .tab:
#	stringz "name"
#	data value
# sequence

/.*[.]size/ {
	inside_table = 0
}

/\/\/ end/ {
	inside_table = 0
}

{
	if (inside_table) {
		if ($1 == "//") getline;
		name=$2
		getline
		getline
		if ($1 == "//") getline;
		value=$2
		len = length(name)
		name = substr(name, 2, len - 2)
		len -= 2
		if (len == 0)
			print ""
		else {
			len += 8
			if (len >= 40) {
				space=" "
			} else {
				space=""
				while (len < 40) {
					len += 8
					space = space"\t"
				}
			}
			printf("#define %s%s%lu\t/* 0x%lx */\n", name, space, value, value)
		}
	}
}

/tab:/ {
	inside_table = 1
}

/tab#:/ {
	inside_table = 1
}

END {
	print ""
	print "#endif /* _ASM_IA64_OFFSETS_H */"
}
