/*
 * Copyright (c) 2016 John Crispin <blogic@openwrt.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __PINCTRL_MTK_MT7623_H
#define __PINCTRL_MTK_MT7623_H

#include <linux/pinctrl/pinctrl.h>
#include "pinctrl-mtk-common.h"

static const struct mtk_desc_pin mtk_pins_mt7623[] = {
	MTK_PIN(
		PINCTRL_PIN(0, "PWRAP_SPI0_MI"),
		"J20", "mt7623",
		MTK_EINT_FUNCTION(0, 148),
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "PWRAP_SPIDO"),
		MTK_FUNCTION(2, "PWRAP_SPIDI")
	),
	MTK_PIN(
		PINCTRL_PIN(1, "PWRAP_SPI0_MO"),
		"D10", "mt7623",
		MTK_EINT_FUNCTION(0, 149),
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "PWRAP_SPIDI"),
		MTK_FUNCTION(2, "PWRAP_SPIDO")
	),
	MTK_PIN(
		PINCTRL_PIN(2, "PWRAP_INT"),
		"E11", "mt7623",
		MTK_EINT_FUNCTION(0, 150),
		MTK_FUNCTION(0, "GPIO2"),
		MTK_FUNCTION(1, "PWRAP_INT")
	),
	MTK_PIN(
		PINCTRL_PIN(3, "PWRAP_SPI0_CK"),
		"H12", "mt7623",
		MTK_EINT_FUNCTION(0, 151),
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "PWRAP_SPICK_I")
	),
	MTK_PIN(
		PINCTRL_PIN(4, "PWRAP_SPI0_CSN"),
		"E12", "mt7623",
		MTK_EINT_FUNCTION(0, 152),
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "PWRAP_SPICS_B_I")
	),
	MTK_PIN(
		PINCTRL_PIN(5, "PWRAP_SPI0_CK2"),
		"H11", "mt7623",
		MTK_EINT_FUNCTION(0, 155),
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "PWRAP_SPICK2_I")
	),
	MTK_PIN(
		PINCTRL_PIN(6, "PWRAP_SPI0_CSN2"),
		"G11", "mt7623",
		MTK_EINT_FUNCTION(0, 156),
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "PWRAP_SPICS2_B_I")
	),
	MTK_PIN(
		PINCTRL_PIN(7, "SPI1_CSN"),
		"G19", "mt7623",
		MTK_EINT_FUNCTION(0, 153),
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "SPI1_CS")
	),
	MTK_PIN(
		PINCTRL_PIN(8, "SPI1_MI"),
		"F19", "mt7623",
		MTK_EINT_FUNCTION(0, 154),
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "SPI1_MI"),
		MTK_FUNCTION(2, "SPI1_MO")
	),
	MTK_PIN(
		PINCTRL_PIN(9, "SPI1_MO"),
		"G20", "mt7623",
		MTK_EINT_FUNCTION(0, 157),
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "SPI1_MO"),
		MTK_FUNCTION(2, "SPI1_MI")
	),
	MTK_PIN(
		PINCTRL_PIN(10, "RTC32K_CK"),
		"A13", "mt7623",
		MTK_EINT_FUNCTION(0, 158),
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "RTC32K_CK")
	),
	MTK_PIN(
		PINCTRL_PIN(11, "WATCHDOG"),
		"D14", "mt7623",
		MTK_EINT_FUNCTION(0, 159),
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(1, "WATCHDOG")
	),
	MTK_PIN(
		PINCTRL_PIN(12, "SRCLKENA"),
		"C13", "mt7623",
		MTK_EINT_FUNCTION(0, 169),
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "SRCLKENA")
	),
	MTK_PIN(
		PINCTRL_PIN(13, "SRCLKENAI"),
		"B13", "mt7623",
		MTK_EINT_FUNCTION(0, 161),
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "SRCLKENAI")
	),
	MTK_PIN(
		PINCTRL_PIN(14, "GPIO14"),
		"E18", "mt7623",
		MTK_EINT_FUNCTION(0, 162),
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "URXD2"),
		MTK_FUNCTION(2, "UTXD2")
	),
	MTK_PIN(
		PINCTRL_PIN(15, "GPIO15"),
		"E17", "mt7623",
		MTK_EINT_FUNCTION(0, 163),
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "UTXD2"),
		MTK_FUNCTION(2, "URXD2")
	),
	MTK_PIN(
		PINCTRL_PIN(16, "GPIO16"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO16")
	),
	MTK_PIN(
		PINCTRL_PIN(17, "GPIO17"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO17")
	),
	MTK_PIN(
		PINCTRL_PIN(18, "PCM_CLK"),
		"C19", "mt7623",
		MTK_EINT_FUNCTION(0, 166),
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "PCM_CLK0"),
		MTK_FUNCTION(6, "AP_PCM_CLKO")
	),
	MTK_PIN(
		PINCTRL_PIN(19, "PCM_SYNC"),
		"D19", "mt7623",
		MTK_EINT_FUNCTION(0, 167),
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "PCM_SYNC"),
		MTK_FUNCTION(6, "AP_PCM_SYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(20, "PCM_RX"),
		"D18", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "PCM_RX"),
		MTK_FUNCTION(4, "PCM_TX"),
		MTK_FUNCTION(6, "AP_PCM_RX")
	),
	MTK_PIN(
		PINCTRL_PIN(21, "PCM_TX"),
		"C18", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "PCM_TX"),
		MTK_FUNCTION(4, "PCM_RX"),
		MTK_FUNCTION(6, "AP_PCM_TX")
	),
	MTK_PIN(
		PINCTRL_PIN(22, "EINT0"),
		"H15", "mt7623",
		MTK_EINT_FUNCTION(0, 0),
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "UCTS0"),
		MTK_FUNCTION(2, "PCIE0_PERST_N")
	),
	MTK_PIN(
		PINCTRL_PIN(23, "EINT1"),
		"J16", "mt7623",
		MTK_EINT_FUNCTION(0, 1),
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "URTS0"),
		MTK_FUNCTION(2, "PCIE1_PERST_N")
	),
	MTK_PIN(
		PINCTRL_PIN(24, "EINT2"),
		"H16", "mt7623",
		MTK_EINT_FUNCTION(0, 2),
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "UCTS1"),
		MTK_FUNCTION(2, "PCIE2_PERST_N")
	),
	MTK_PIN(
		PINCTRL_PIN(25, "EINT3"),
		"K15", "mt7623",
		MTK_EINT_FUNCTION(0, 3),
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "URTS1")
	),
	MTK_PIN(
		PINCTRL_PIN(26, "EINT4"),
		"G15", "mt7623",
		MTK_EINT_FUNCTION(0, 4),
		MTK_FUNCTION(0, "GPIO26"),
		MTK_FUNCTION(1, "UCTS3"),
		MTK_FUNCTION(6, "PCIE2_WAKE_N")
	),
	MTK_PIN(
		PINCTRL_PIN(27, "EINT5"),
		"F15", "mt7623",
		MTK_EINT_FUNCTION(0, 5),
		MTK_FUNCTION(0, "GPIO27"),
		MTK_FUNCTION(1, "URTS3"),
		MTK_FUNCTION(6, "PCIE1_WAKE_N")
	),
	MTK_PIN(
		PINCTRL_PIN(28, "EINT6"),
		"J15", "mt7623",
		MTK_EINT_FUNCTION(0, 6),
		MTK_FUNCTION(0, "GPIO28"),
		MTK_FUNCTION(1, "DRV_VBUS"),
		MTK_FUNCTION(6, "PCIE0_WAKE_N")
	),
	MTK_PIN(
		PINCTRL_PIN(29, "EINT7"),
		"E15", "mt7623",
		MTK_EINT_FUNCTION(0, 7),
		MTK_FUNCTION(0, "GPIO29"),
		MTK_FUNCTION(1, "IDDIG"),
		MTK_FUNCTION(2, "MSDC1_WP"),
		MTK_FUNCTION(6, "PCIE2_PERST_N")
	),
	MTK_PIN(
		PINCTRL_PIN(30, "GPIO30"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO30")
	),
	MTK_PIN(
		PINCTRL_PIN(31, "GPIO31"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO31")
	),
	MTK_PIN(
		PINCTRL_PIN(32, "GPIO32"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO32")
	),
	MTK_PIN(
		PINCTRL_PIN(33, "I2S1_DATA"),
		"Y18", "mt7623",
		MTK_EINT_FUNCTION(0, 15),
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "I2S1_DATA"),
		MTK_FUNCTION(3, "PCM_TX"),
		MTK_FUNCTION(6, "AP_PCM_TX")
	),
	MTK_PIN(
		PINCTRL_PIN(34, "I2S1_DATA_IN"),
		"Y17", "mt7623",
		MTK_EINT_FUNCTION(0, 16),
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(1, "I2S1_DATA_IN"),
		MTK_FUNCTION(3, "PCM_RX"),
		MTK_FUNCTION(6, "AP_PCM_RX")
	),
	MTK_PIN(
		PINCTRL_PIN(35, "I2S1_BCK"),
		"V17", "mt7623",
		MTK_EINT_FUNCTION(0, 17),
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "I2S1_BCK"),
		MTK_FUNCTION(3, "PCM_CLK0"),
		MTK_FUNCTION(6, "AP_PCM_CLKO")
	),
	MTK_PIN(
		PINCTRL_PIN(36, "I2S1_LRCK"),
		"W17", "mt7623",
		MTK_EINT_FUNCTION(0, 18),
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(1, "I2S1_LRCK"),
		MTK_FUNCTION(3, "PCM_SYNC"),
		MTK_FUNCTION(6, "AP_PCM_SYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(37, "I2S1_MCLK"),
		"AA18", "mt7623",
		MTK_EINT_FUNCTION(0, 19),
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "I2S1_MCLK")
	),
	MTK_PIN(
		PINCTRL_PIN(38, "GPIO38"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO38")
	),
	MTK_PIN(
		PINCTRL_PIN(39, "JTMS"),
		"G21", "mt7623",
		MTK_EINT_FUNCTION(0, 21),
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "JTMS")
	),
	MTK_PIN(
		PINCTRL_PIN(40, "GPIO40"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO40")
	),
	MTK_PIN(
		PINCTRL_PIN(41, "JTDI"),
		"H22", "mt7623",
		MTK_EINT_FUNCTION(0, 23),
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "JTDI")
	),
	MTK_PIN(
		PINCTRL_PIN(42, "JTDO"),
		"H21", "mt7623",
		MTK_EINT_FUNCTION(0, 24),
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "JTDO")
	),
	MTK_PIN(
		PINCTRL_PIN(43, "NCLE"),
		"C7", "mt7623",
		MTK_EINT_FUNCTION(0, 25),
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "NCLE"),
		MTK_FUNCTION(2, "EXT_XCS2")
	),
	MTK_PIN(
		PINCTRL_PIN(44, "NCEB1"),
		"C6", "mt7623",
		MTK_EINT_FUNCTION(0, 26),
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "NCEB1"),
		MTK_FUNCTION(2, "IDDIG")
	),
	MTK_PIN(
		PINCTRL_PIN(45, "NCEB0"),
		"D7", "mt7623",
		MTK_EINT_FUNCTION(0, 27),
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(1, "NCEB0"),
		MTK_FUNCTION(2, "DRV_VBUS")
	),
	MTK_PIN(
		PINCTRL_PIN(46, "IR"),
		"D15", "mt7623",
		MTK_EINT_FUNCTION(0, 28),
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(1, "IR")
	),
	MTK_PIN(
		PINCTRL_PIN(47, "NREB"),
		"A6", "mt7623",
		MTK_EINT_FUNCTION(0, 29),
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(1, "NREB")
	),
	MTK_PIN(
		PINCTRL_PIN(48, "NRNB"),
		"B6", "mt7623",
		MTK_EINT_FUNCTION(0, 30),
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(1, "NRNB")
	),
	MTK_PIN(
		PINCTRL_PIN(49, "I2S0_DATA"),
		"AB18", "mt7623",
		MTK_EINT_FUNCTION(0, 31),
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "I2S0_DATA"),
		MTK_FUNCTION(3, "PCM_TX"),
		MTK_FUNCTION(6, "AP_I2S_DO")
	),
	MTK_PIN(
		PINCTRL_PIN(50, "GPIO50"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO50")
	),
	MTK_PIN(
		PINCTRL_PIN(51, "GPIO51"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO51")
	),
	MTK_PIN(
		PINCTRL_PIN(52, "GPIO52"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO52")
	),
	MTK_PIN(
		PINCTRL_PIN(53, "SPI0_CSN"),
		"E7", "mt7623",
		MTK_EINT_FUNCTION(0, 35),
		MTK_FUNCTION(0, "GPIO53"),
		MTK_FUNCTION(1, "SPI0_CS"),
		MTK_FUNCTION(5, "PWM1")
	),
	MTK_PIN(
		PINCTRL_PIN(54, "SPI0_CK"),
		"F7", "mt7623",
		MTK_EINT_FUNCTION(0, 36),
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "SPI0_CK")
	),
	MTK_PIN(
		PINCTRL_PIN(55, "SPI0_MI"),
		"E6", "mt7623",
		MTK_EINT_FUNCTION(0, 37),
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "SPI0_MI"),
		MTK_FUNCTION(2, "SPI0_MO"),
		MTK_FUNCTION(3, "MSDC1_WP"),
		MTK_FUNCTION(5, "PWM2")
	),
	MTK_PIN(
		PINCTRL_PIN(56, "SPI0_MO"),
		"G7", "mt7623",
		MTK_EINT_FUNCTION(0, 38),
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "SPI0_MO"),
		MTK_FUNCTION(2, "SPI0_MI")
	),
	MTK_PIN(
		PINCTRL_PIN(57, "GPIO57"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO57")
	),
	MTK_PIN(
		PINCTRL_PIN(58, "GPIO58"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO58")
	),
	MTK_PIN(
		PINCTRL_PIN(59, "GPIO59"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO59")
	),
	MTK_PIN(
		PINCTRL_PIN(60, "WB_RSTB"),
		"Y21", "mt7623",
		MTK_EINT_FUNCTION(0, 41),
		MTK_FUNCTION(0, "GPIO60"),
		MTK_FUNCTION(1, "WB_RSTB")
	),
	MTK_PIN(
		PINCTRL_PIN(61, "GPIO61"),
		"AA21", "mt7623",
		MTK_EINT_FUNCTION(0, 42),
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "TEST_FD")
	),
	MTK_PIN(
		PINCTRL_PIN(62, "GPIO62"),
		"AB22", "mt7623",
		MTK_EINT_FUNCTION(0, 43),
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "TEST_FC")
	),
	MTK_PIN(
		PINCTRL_PIN(63, "WB_SCLK"),
		"AC23", "mt7623",
		MTK_EINT_FUNCTION(0, 44),
		MTK_FUNCTION(0, "GPIO63"),
		MTK_FUNCTION(1, "WB_SCLK")
	),
	MTK_PIN(
		PINCTRL_PIN(64, "WB_SDATA"),
		"AB21", "mt7623",
		MTK_EINT_FUNCTION(0, 45),
		MTK_FUNCTION(0, "GPIO64"),
		MTK_FUNCTION(1, "WB_SDATA")
	),
	MTK_PIN(
		PINCTRL_PIN(65, "WB_SEN"),
		"AB24", "mt7623",
		MTK_EINT_FUNCTION(0, 46),
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "WB_SEN")
	),
	MTK_PIN(
		PINCTRL_PIN(66, "WB_CRTL0"),
		"AB20", "mt7623",
		MTK_EINT_FUNCTION(0, 47),
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "WB_CRTL0")
	),
	MTK_PIN(
		PINCTRL_PIN(67, "WB_CRTL1"),
		"AC20", "mt7623",
		MTK_EINT_FUNCTION(0, 48),
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(1, "WB_CRTL1")
	),
	MTK_PIN(
		PINCTRL_PIN(68, "WB_CRTL2"),
		"AB19", "mt7623",
		MTK_EINT_FUNCTION(0, 49),
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "WB_CRTL2")
	),
	MTK_PIN(
		PINCTRL_PIN(69, "WB_CRTL3"),
		"AC19", "mt7623",
		MTK_EINT_FUNCTION(0, 50),
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "WB_CRTL3")
	),
	MTK_PIN(
		PINCTRL_PIN(70, "WB_CRTL4"),
		"AD19", "mt7623",
		MTK_EINT_FUNCTION(0, 51),
		MTK_FUNCTION(0, "GPIO70"),
		MTK_FUNCTION(1, "WB_CRTL4")
	),
	MTK_PIN(
		PINCTRL_PIN(71, "WB_CRTL5"),
		"AE19", "mt7623",
		MTK_EINT_FUNCTION(0, 52),
		MTK_FUNCTION(0, "GPIO71"),
		MTK_FUNCTION(1, "WB_CRTL5")
	),
	MTK_PIN(
		PINCTRL_PIN(72, "I2S0_DATA_IN"),
		"AA20", "mt7623",
		MTK_EINT_FUNCTION(0, 53),
		MTK_FUNCTION(0, "GPIO72"),
		MTK_FUNCTION(1, "I2S0_DATA_IN"),
		MTK_FUNCTION(3, "PCM_RX"),
		MTK_FUNCTION(4, "PWM0"),
		MTK_FUNCTION(5, "DISP_PWM"),
		MTK_FUNCTION(6, "AP_I2S_DI")
	),
	MTK_PIN(
		PINCTRL_PIN(73, "I2S0_LRCK"),
		"Y20", "mt7623",
		MTK_EINT_FUNCTION(0, 54),
		MTK_FUNCTION(0, "GPIO73"),
		MTK_FUNCTION(1, "I2S0_LRCK"),
		MTK_FUNCTION(3, "PCM_SYNC"),
		MTK_FUNCTION(6, "AP_I2S_LRCK")
	),
	MTK_PIN(
		PINCTRL_PIN(74, "I2S0_BCK"),
		"Y19", "mt7623",
		MTK_EINT_FUNCTION(0, 55),
		MTK_FUNCTION(0, "GPIO74"),
		MTK_FUNCTION(1, "I2S0_BCK"),
		MTK_FUNCTION(3, "PCM_CLK0"),
		MTK_FUNCTION(6, "AP_I2S_BCK")
	),
	MTK_PIN(
		PINCTRL_PIN(75, "SDA0"),
		"K19", "mt7623",
		MTK_EINT_FUNCTION(0, 56),
		MTK_FUNCTION(0, "GPIO75"),
		MTK_FUNCTION(1, "SDA0")
	),
	MTK_PIN(
		PINCTRL_PIN(76, "SCL0"),
		"K20", "mt7623",
		MTK_EINT_FUNCTION(0, 57),
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "SCL0")
	),
	MTK_PIN(
		PINCTRL_PIN(77, "GPIO77"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO77")
	),
	MTK_PIN(
		PINCTRL_PIN(78, "GPIO78"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO78")
	),
	MTK_PIN(
		PINCTRL_PIN(79, "GPIO79"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO79")
	),
	MTK_PIN(
		PINCTRL_PIN(80, "GPIO80"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO80")
	),
	MTK_PIN(
		PINCTRL_PIN(81, "GPIO81"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO81")
	),
	MTK_PIN(
		PINCTRL_PIN(82, "GPIO82"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO82")
	),
	MTK_PIN(
		PINCTRL_PIN(83, "LCM_RST"),
		"V16", "mt7623",
		MTK_EINT_FUNCTION(0, 64),
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "LCM_RST")
	),
	MTK_PIN(
		PINCTRL_PIN(84, "DSI_TE"),
		"V14", "mt7623",
		MTK_EINT_FUNCTION(0, 65),
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "DSI_TE")
	),
	MTK_PIN(
		PINCTRL_PIN(85, "GPIO85"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO85")
	),
	MTK_PIN(
		PINCTRL_PIN(86, "GPIO86"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO86")
	),
	MTK_PIN(
		PINCTRL_PIN(87, "GPIO87"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO87")
	),
	MTK_PIN(
		PINCTRL_PIN(88, "GPIO88"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO88")
	),
	MTK_PIN(
		PINCTRL_PIN(89, "GPIO89"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO89")
	),
	MTK_PIN(
		PINCTRL_PIN(90, "GPIO90"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO90")
	),
	MTK_PIN(
		PINCTRL_PIN(91, "GPIO91"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO91")
	),
	MTK_PIN(
		PINCTRL_PIN(92, "GPIO92"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO92")
	),
	MTK_PIN(
		PINCTRL_PIN(93, "GPIO93"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO93")
	),
	MTK_PIN(
		PINCTRL_PIN(94, "GPIO94"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO94")
	),
	MTK_PIN(
		PINCTRL_PIN(95, "MIPI_TCN"),
		"AB14", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO95"),
		MTK_FUNCTION(1, "TCN")
	),
	MTK_PIN(
		PINCTRL_PIN(96, "MIPI_TCP"),
		"AC14", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO96"),
		MTK_FUNCTION(1, "TCP")
	),
	MTK_PIN(
		PINCTRL_PIN(97, "MIPI_TDN1"),
		"AE15", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO97"),
		MTK_FUNCTION(1, "TDN1")
	),
	MTK_PIN(
		PINCTRL_PIN(98, "MIPI_TDP1"),
		"AD15", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO98"),
		MTK_FUNCTION(1, "TDP1")
	),
	MTK_PIN(
		PINCTRL_PIN(99, "MIPI_TDN0"),
		"AB15", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO99"),
		MTK_FUNCTION(1, "TDN0")
	),
	MTK_PIN(
		PINCTRL_PIN(100, "MIPI_TDP0"),
		"AC15", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO100"),
		MTK_FUNCTION(1, "TDP0")
	),
	MTK_PIN(
		PINCTRL_PIN(101, "GPIO101"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO101")
	),
	MTK_PIN(
		PINCTRL_PIN(102, "GPIO102"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO102")
	),
	MTK_PIN(
		PINCTRL_PIN(103, "GPIO103"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO103")
	),
	MTK_PIN(
		PINCTRL_PIN(104, "GPIO104"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO104")
	),
	MTK_PIN(
		PINCTRL_PIN(105, "MSDC1_CMD"),
		"AD2", "mt7623",
		MTK_EINT_FUNCTION(0, 78),
		MTK_FUNCTION(0, "GPIO105"),
		MTK_FUNCTION(1, "MSDC1_CMD"),
		MTK_FUNCTION(3, "SDA1"),
		MTK_FUNCTION(6, "I2SOUT_BCK")
	),
	MTK_PIN(
		PINCTRL_PIN(106, "MSDC1_CLK"),
		"AD3", "mt7623",
		MTK_EINT_FUNCTION(0, 79),
		MTK_FUNCTION(0, "GPIO106"),
		MTK_FUNCTION(1, "MSDC1_CLK"),
		MTK_FUNCTION(3, "SCL1"),
		MTK_FUNCTION(6, "I2SOUT_LRCK")
	),
	MTK_PIN(
		PINCTRL_PIN(107, "MSDC1_DAT0"),
		"AE2", "mt7623",
		MTK_EINT_FUNCTION(0, 80),
		MTK_FUNCTION(0, "GPIO107"),
		MTK_FUNCTION(1, "MSDC1_DAT0"),
		MTK_FUNCTION(5, "UTXD0"),
		MTK_FUNCTION(6, "I2SOUT_DATA_OUT")
	),
	MTK_PIN(
		PINCTRL_PIN(108, "MSDC1_DAT1"),
		"AC1", "mt7623",
		MTK_EINT_FUNCTION(0, 81),
		MTK_FUNCTION(0, "GPIO108"),
		MTK_FUNCTION(1, "MSDC1_DAT1"),
		MTK_FUNCTION(3, "PWM0"),
		MTK_FUNCTION(5, "URXD0"),
		MTK_FUNCTION(6, "PWM1")
	),
	MTK_PIN(
		PINCTRL_PIN(109, "MSDC1_DAT2"),
		"AC3", "mt7623",
		MTK_EINT_FUNCTION(0, 82),
		MTK_FUNCTION(0, "GPIO109"),
		MTK_FUNCTION(1, "MSDC1_DAT2"),
		MTK_FUNCTION(3, "SDA2"),
		MTK_FUNCTION(5, "UTXD1"),
		MTK_FUNCTION(6, "PWM2")
	),
	MTK_PIN(
		PINCTRL_PIN(110, "MSDC1_DAT3"),
		"AC4", "mt7623",
		MTK_EINT_FUNCTION(0, 83),
		MTK_FUNCTION(0, "GPIO110"),
		MTK_FUNCTION(1, "MSDC1_DAT3"),
		MTK_FUNCTION(3, "SCL2"),
		MTK_FUNCTION(5, "URXD1"),
		MTK_FUNCTION(6, "PWM3")
	),
	MTK_PIN(
		PINCTRL_PIN(111, "MSDC0_DAT7"),
		"A2", "mt7623",
		MTK_EINT_FUNCTION(0, 84),
		MTK_FUNCTION(0, "GPIO111"),
		MTK_FUNCTION(1, "MSDC0_DAT7"),
		MTK_FUNCTION(4, "NLD7")
	),
	MTK_PIN(
		PINCTRL_PIN(112, "MSDC0_DAT6"),
		"B3", "mt7623",
		MTK_EINT_FUNCTION(0, 85),
		MTK_FUNCTION(0, "GPIO112"),
		MTK_FUNCTION(1, "MSDC0_DAT6"),
		MTK_FUNCTION(4, "NLD6")
	),
	MTK_PIN(
		PINCTRL_PIN(113, "MSDC0_DAT5"),
		"C4", "mt7623",
		MTK_EINT_FUNCTION(0, 86),
		MTK_FUNCTION(0, "GPIO113"),
		MTK_FUNCTION(1, "MSDC0_DAT5"),
		MTK_FUNCTION(4, "NLD5")
	),
	MTK_PIN(
		PINCTRL_PIN(114, "MSDC0_DAT4"),
		"A4", "mt7623",
		MTK_EINT_FUNCTION(0, 87),
		MTK_FUNCTION(0, "GPIO114"),
		MTK_FUNCTION(1, "MSDC0_DAT4"),
		MTK_FUNCTION(4, "NLD4")
	),
	MTK_PIN(
		PINCTRL_PIN(115, "MSDC0_RSTB"),
		"C5", "mt7623",
		MTK_EINT_FUNCTION(0, 88),
		MTK_FUNCTION(0, "GPIO115"),
		MTK_FUNCTION(1, "MSDC0_RSTB"),
		MTK_FUNCTION(4, "NLD8")
	),
	MTK_PIN(
		PINCTRL_PIN(116, "MSDC0_CMD"),
		"D5", "mt7623",
		MTK_EINT_FUNCTION(0, 89),
		MTK_FUNCTION(0, "GPIO116"),
		MTK_FUNCTION(1, "MSDC0_CMD"),
		MTK_FUNCTION(4, "NALE")
	),
	MTK_PIN(
		PINCTRL_PIN(117, "MSDC0_CLK"),
		"B1", "mt7623",
		MTK_EINT_FUNCTION(0, 90),
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "MSDC0_CLK"),
		MTK_FUNCTION(4, "NWEB")
	),
	MTK_PIN(
		PINCTRL_PIN(118, "MSDC0_DAT3"),
		"D6", "mt7623",
		MTK_EINT_FUNCTION(0, 91),
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "MSDC0_DAT3"),
		MTK_FUNCTION(4, "NLD3")
	),
	MTK_PIN(
		PINCTRL_PIN(119, "MSDC0_DAT2"),
		"B2", "mt7623",
		MTK_EINT_FUNCTION(0, 92),
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "MSDC0_DAT2"),
		MTK_FUNCTION(4, "NLD2")
	),
	MTK_PIN(
		PINCTRL_PIN(120, "MSDC0_DAT1"),
		"A3", "mt7623",
		MTK_EINT_FUNCTION(0, 93),
		MTK_FUNCTION(0, "GPIO120"),
		MTK_FUNCTION(1, "MSDC0_DAT1"),
		MTK_FUNCTION(4, "NLD1")
	),
	MTK_PIN(
		PINCTRL_PIN(121, "MSDC0_DAT0"),
		"B4", "mt7623",
		MTK_EINT_FUNCTION(0, 94),
		MTK_FUNCTION(0, "GPIO121"),
		MTK_FUNCTION(1, "MSDC0_DAT0"),
		MTK_FUNCTION(4, "NLD0"),
		MTK_FUNCTION(5, "WATCHDOG")
	),
	MTK_PIN(
		PINCTRL_PIN(122, "GPIO122"),
		"H17", "mt7623",
		MTK_EINT_FUNCTION(0, 95),
		MTK_FUNCTION(0, "GPIO122"),
		MTK_FUNCTION(1, "TEST"),
		MTK_FUNCTION(4, "SDA2"),
		MTK_FUNCTION(5, "URXD0")
	),
	MTK_PIN(
		PINCTRL_PIN(123, "GPIO123"),
		"F17", "mt7623",
		MTK_EINT_FUNCTION(0, 96),
		MTK_FUNCTION(0, "GPIO123"),
		MTK_FUNCTION(1, "TEST"),
		MTK_FUNCTION(4, "SCL2"),
		MTK_FUNCTION(5, "UTXD0")
	),
	MTK_PIN(
		PINCTRL_PIN(124, "GPIO124"),
		"H18", "mt7623",
		MTK_EINT_FUNCTION(0, 97),
		MTK_FUNCTION(0, "GPIO124"),
		MTK_FUNCTION(1, "TEST"),
		MTK_FUNCTION(4, "SDA1"),
		MTK_FUNCTION(5, "PWM3")
	),
	MTK_PIN(
		PINCTRL_PIN(125, "GPIO125"),
		"G17", "mt7623",
		MTK_EINT_FUNCTION(0, 98),
		MTK_FUNCTION(0, "GPIO125"),
		MTK_FUNCTION(1, "TEST"),
		MTK_FUNCTION(4, "SCL1"),
		MTK_FUNCTION(5, "PWM4")
	),
	MTK_PIN(
		PINCTRL_PIN(126, "I2S0_MCLK"),
		"AA19", "mt7623",
		MTK_EINT_FUNCTION(0, 99),
		MTK_FUNCTION(0, "GPIO126"),
		MTK_FUNCTION(1, "I2S0_MCLK"),
		MTK_FUNCTION(6, "AP_I2S_MCLK")
	),
	MTK_PIN(
		PINCTRL_PIN(127, "GPIO127"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO127")
	),
	MTK_PIN(
		PINCTRL_PIN(128, "GPIO128"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO128")
	),
	MTK_PIN(
		PINCTRL_PIN(129, "GPIO129"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO129")
	),
	MTK_PIN(
		PINCTRL_PIN(130, "GPIO130"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO130")
	),
	MTK_PIN(
		PINCTRL_PIN(131, "GPIO131"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO131")
	),
	MTK_PIN(
		PINCTRL_PIN(132, "GPIO132"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO132")
	),
	MTK_PIN(
		PINCTRL_PIN(133, "GPIO133"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO133")
	),
	MTK_PIN(
		PINCTRL_PIN(134, "GPIO134"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO134")
	),
	MTK_PIN(
		PINCTRL_PIN(135, "GPIO135"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO135")
	),
	MTK_PIN(
		PINCTRL_PIN(136, "GPIO136"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO136")
	),
	MTK_PIN(
		PINCTRL_PIN(137, "GPIO137"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO137")
	),
	MTK_PIN(
		PINCTRL_PIN(138, "GPIO138"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO138")
	),
	MTK_PIN(
		PINCTRL_PIN(139, "GPIO139"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO139")
	),
	MTK_PIN(
		PINCTRL_PIN(140, "GPIO140"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO140")
	),
	MTK_PIN(
		PINCTRL_PIN(141, "GPIO141"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO141")
	),
	MTK_PIN(
		PINCTRL_PIN(142, "GPIO142"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO142")
	),
	MTK_PIN(
		PINCTRL_PIN(143, "GPIO143"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO143")
	),
	MTK_PIN(
		PINCTRL_PIN(144, "GPIO144"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO144")
	),
	MTK_PIN(
		PINCTRL_PIN(145, "GPIO145"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO145")
	),
	MTK_PIN(
		PINCTRL_PIN(146, "GPIO146"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO146")
	),
	MTK_PIN(
		PINCTRL_PIN(147, "GPIO147"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO147")
	),
	MTK_PIN(
		PINCTRL_PIN(148, "GPIO148"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO148")
	),
	MTK_PIN(
		PINCTRL_PIN(149, "GPIO149"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO149")
	),
	MTK_PIN(
		PINCTRL_PIN(150, "GPIO150"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO150")
	),
	MTK_PIN(
		PINCTRL_PIN(151, "GPIO151"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO151")
	),
	MTK_PIN(
		PINCTRL_PIN(152, "GPIO152"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO152")
	),
	MTK_PIN(
		PINCTRL_PIN(153, "GPIO153"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO153")
	),
	MTK_PIN(
		PINCTRL_PIN(154, "GPIO154"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO154")
	),
	MTK_PIN(
		PINCTRL_PIN(155, "GPIO155"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO155")
	),
	MTK_PIN(
		PINCTRL_PIN(156, "GPIO156"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO156")
	),
	MTK_PIN(
		PINCTRL_PIN(157, "GPIO157"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO157")
	),
	MTK_PIN(
		PINCTRL_PIN(158, "GPIO158"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO158")
	),
	MTK_PIN(
		PINCTRL_PIN(159, "GPIO159"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO159")
	),
	MTK_PIN(
		PINCTRL_PIN(160, "GPIO160"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO160")
	),
	MTK_PIN(
		PINCTRL_PIN(161, "GPIO161"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO161")
	),
	MTK_PIN(
		PINCTRL_PIN(162, "GPIO162"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO162")
	),
	MTK_PIN(
		PINCTRL_PIN(163, "GPIO163"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO163")
	),
	MTK_PIN(
		PINCTRL_PIN(164, "GPIO164"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO164")
	),
	MTK_PIN(
		PINCTRL_PIN(165, "GPIO165"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO165")
	),
	MTK_PIN(
		PINCTRL_PIN(166, "GPIO166"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO166")
	),
	MTK_PIN(
		PINCTRL_PIN(167, "GPIO167"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO167")
	),
	MTK_PIN(
		PINCTRL_PIN(168, "GPIO168"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO168")
	),
	MTK_PIN(
		PINCTRL_PIN(169, "GPIO169"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO169")
	),
	MTK_PIN(
		PINCTRL_PIN(170, "GPIO170"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO170")
	),
	MTK_PIN(
		PINCTRL_PIN(171, "GPIO171"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO171")
	),
	MTK_PIN(
		PINCTRL_PIN(172, "GPIO172"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO172")
	),
	MTK_PIN(
		PINCTRL_PIN(173, "GPIO173"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO173")
	),
	MTK_PIN(
		PINCTRL_PIN(174, "GPIO174"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO174")
	),
	MTK_PIN(
		PINCTRL_PIN(175, "GPIO175"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO175")
	),
	MTK_PIN(
		PINCTRL_PIN(176, "GPIO176"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO176")
	),
	MTK_PIN(
		PINCTRL_PIN(177, "GPIO177"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO177")
	),
	MTK_PIN(
		PINCTRL_PIN(178, "GPIO178"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO178")
	),
	MTK_PIN(
		PINCTRL_PIN(179, "GPIO179"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO179")
	),
	MTK_PIN(
		PINCTRL_PIN(180, "GPIO180"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO180")
	),
	MTK_PIN(
		PINCTRL_PIN(181, "GPIO181"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO181")
	),
	MTK_PIN(
		PINCTRL_PIN(182, "GPIO182"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO182")
	),
	MTK_PIN(
		PINCTRL_PIN(183, "GPIO183"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO183")
	),
	MTK_PIN(
		PINCTRL_PIN(184, "GPIO184"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO184")
	),
	MTK_PIN(
		PINCTRL_PIN(185, "GPIO185"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO185")
	),
	MTK_PIN(
		PINCTRL_PIN(186, "GPIO186"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO186")
	),
	MTK_PIN(
		PINCTRL_PIN(187, "GPIO187"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO187")
	),
	MTK_PIN(
		PINCTRL_PIN(188, "GPIO188"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO188")
	),
	MTK_PIN(
		PINCTRL_PIN(189, "GPIO189"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO189")
	),
	MTK_PIN(
		PINCTRL_PIN(190, "GPIO190"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO190")
	),
	MTK_PIN(
		PINCTRL_PIN(191, "GPIO191"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO191")
	),
	MTK_PIN(
		PINCTRL_PIN(192, "GPIO192"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO192")
	),
	MTK_PIN(
		PINCTRL_PIN(193, "GPIO193"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO193")
	),
	MTK_PIN(
		PINCTRL_PIN(194, "GPIO194"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO194")
	),
	MTK_PIN(
		PINCTRL_PIN(195, "GPIO195"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO195")
	),
	MTK_PIN(
		PINCTRL_PIN(196, "GPIO196"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO196")
	),
	MTK_PIN(
		PINCTRL_PIN(197, "GPIO197"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO197")
	),
	MTK_PIN(
		PINCTRL_PIN(198, "GPIO198"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO198")
	),
	MTK_PIN(
		PINCTRL_PIN(199, "SPI1_CK"),
		"E19", "mt7623",
		MTK_EINT_FUNCTION(0, 111),
		MTK_FUNCTION(0, "GPIO199"),
		MTK_FUNCTION(1, "SPI1_CK")
	),
	MTK_PIN(
		PINCTRL_PIN(200, "URXD2"),
		"K18", "mt7623",
		MTK_EINT_FUNCTION(0, 112),
		MTK_FUNCTION(0, "GPIO200"),
		MTK_FUNCTION(6, "URXD2")
	),
	MTK_PIN(
		PINCTRL_PIN(201, "UTXD2"),
		"L18", "mt7623",
		MTK_EINT_FUNCTION(0, 113),
		MTK_FUNCTION(0, "GPIO201"),
		MTK_FUNCTION(6, "UTXD2")
	),
	MTK_PIN(
		PINCTRL_PIN(202, "GPIO202"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO202")
	),
	MTK_PIN(
		PINCTRL_PIN(203, "PWM0"),
		"AA16", "mt7623",
		MTK_EINT_FUNCTION(0, 115),
		MTK_FUNCTION(0, "GPIO203"),
		MTK_FUNCTION(1, "PWM0"),
		MTK_FUNCTION(2, "DISP_PWM")
	),
	MTK_PIN(
		PINCTRL_PIN(204, "PWM1"),
		"Y16", "mt7623",
		MTK_EINT_FUNCTION(0, 116),
		MTK_FUNCTION(0, "GPIO204"),
		MTK_FUNCTION(1, "PWM1")
	),
	MTK_PIN(
		PINCTRL_PIN(205, "PWM2"),
		"AA15", "mt7623",
		MTK_EINT_FUNCTION(0, 117),
		MTK_FUNCTION(0, "GPIO205"),
		MTK_FUNCTION(1, "PWM2")
	),
	MTK_PIN(
		PINCTRL_PIN(206, "PWM3"),
		"AA17", "mt7623",
		MTK_EINT_FUNCTION(0, 118),
		MTK_FUNCTION(0, "GPIO206"),
		MTK_FUNCTION(1, "PWM3")
	),
	MTK_PIN(
		PINCTRL_PIN(207, "PWM4"),
		"Y15", "mt7623",
		MTK_EINT_FUNCTION(0, 119),
		MTK_FUNCTION(0, "GPIO207"),
		MTK_FUNCTION(1, "PWM4")
	),
	MTK_PIN(
		PINCTRL_PIN(208, "AUD_EXT_CK1"),
		"W14", "mt7623",
		MTK_EINT_FUNCTION(0, 120),
		MTK_FUNCTION(0, "GPIO208"),
		MTK_FUNCTION(1, "AUD_EXT_CK1"),
		MTK_FUNCTION(2, "PWM0"),
		MTK_FUNCTION(3, "PCIE0_PERST_N"),
		MTK_FUNCTION(5, "DISP_PWM")
	),
	MTK_PIN(
		PINCTRL_PIN(209, "AUD_EXT_CK2"),
		"V15", "mt7623",
		MTK_EINT_FUNCTION(0, 121),
		MTK_FUNCTION(0, "GPIO209"),
		MTK_FUNCTION(1, "AUD_EXT_CK2"),
		MTK_FUNCTION(2, "MSDC1_WP"),
		MTK_FUNCTION(3, "PCIE1_PERST_N"),
		MTK_FUNCTION(5, "PWM1")
	),
	MTK_PIN(
		PINCTRL_PIN(210, "GPIO210"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO210")
	),
	MTK_PIN(
		PINCTRL_PIN(211, "GPIO211"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO211")
	),
	MTK_PIN(
		PINCTRL_PIN(212, "GPIO212"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO212")
	),
	MTK_PIN(
		PINCTRL_PIN(213, "GPIO213"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO213")
	),
	MTK_PIN(
		PINCTRL_PIN(214, "GPIO214"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO214")
	),
	MTK_PIN(
		PINCTRL_PIN(215, "GPIO215"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO215")
	),
	MTK_PIN(
		PINCTRL_PIN(216, "GPIO216"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO216")
	),
	MTK_PIN(
		PINCTRL_PIN(217, "GPIO217"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO217")
	),
	MTK_PIN(
		PINCTRL_PIN(218, "GPIO218"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO218")
	),
	MTK_PIN(
		PINCTRL_PIN(219, "GPIO219"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO219")
	),
	MTK_PIN(
		PINCTRL_PIN(220, "GPIO220"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO220")
	),
	MTK_PIN(
		PINCTRL_PIN(221, "GPIO221"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO221")
	),
	MTK_PIN(
		PINCTRL_PIN(222, "GPIO222"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO222")
	),
	MTK_PIN(
		PINCTRL_PIN(223, "GPIO223"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO223")
	),
	MTK_PIN(
		PINCTRL_PIN(224, "GPIO224"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO224")
	),
	MTK_PIN(
		PINCTRL_PIN(225, "GPIO225"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO225")
	),
	MTK_PIN(
		PINCTRL_PIN(226, "GPIO226"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO226")
	),
	MTK_PIN(
		PINCTRL_PIN(227, "GPIO227"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO227")
	),
	MTK_PIN(
		PINCTRL_PIN(228, "GPIO228"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO228")
	),
	MTK_PIN(
		PINCTRL_PIN(229, "GPIO229"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO229")
	),
	MTK_PIN(
		PINCTRL_PIN(230, "GPIO230"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO230")
	),
	MTK_PIN(
		PINCTRL_PIN(231, "GPIO231"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO231")
	),
	MTK_PIN(
		PINCTRL_PIN(232, "GPIO232"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO232")
	),
	MTK_PIN(
		PINCTRL_PIN(233, "GPIO233"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO233")
	),
	MTK_PIN(
		PINCTRL_PIN(234, "GPIO234"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO234")
	),
	MTK_PIN(
		PINCTRL_PIN(235, "GPIO235"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO235")
	),
	MTK_PIN(
		PINCTRL_PIN(236, "EXT_SDIO3"),
		"A8", "mt7623",
		MTK_EINT_FUNCTION(0, 122),
		MTK_FUNCTION(0, "GPIO236"),
		MTK_FUNCTION(1, "EXT_SDIO3"),
		MTK_FUNCTION(2, "IDDIG")
	),
	MTK_PIN(
		PINCTRL_PIN(237, "EXT_SDIO2"),
		"D8", "mt7623",
		MTK_EINT_FUNCTION(0, 123),
		MTK_FUNCTION(0, "GPIO237"),
		MTK_FUNCTION(1, "EXT_SDIO2"),
		MTK_FUNCTION(2, "DRV_VBUS")
	),
	MTK_PIN(
		PINCTRL_PIN(238, "EXT_SDIO1"),
		"D9", "mt7623",
		MTK_EINT_FUNCTION(0, 124),
		MTK_FUNCTION(0, "GPIO238"),
		MTK_FUNCTION(1, "EXT_SDIO1")
	),
	MTK_PIN(
		PINCTRL_PIN(239, "EXT_SDIO0"),
		"B8", "mt7623",
		MTK_EINT_FUNCTION(0, 125),
		MTK_FUNCTION(0, "GPIO239"),
		MTK_FUNCTION(1, "EXT_SDIO0")
	),
	MTK_PIN(
		PINCTRL_PIN(240, "EXT_XCS"),
		"C9", "mt7623",
		MTK_EINT_FUNCTION(0, 126),
		MTK_FUNCTION(0, "GPIO240"),
		MTK_FUNCTION(1, "EXT_XCS")
	),
	MTK_PIN(
		PINCTRL_PIN(241, "EXT_SCK"),
		"C8", "mt7623",
		MTK_EINT_FUNCTION(0, 127),
		MTK_FUNCTION(0, "GPIO241"),
		MTK_FUNCTION(1, "EXT_SCK")
	),
	MTK_PIN(
		PINCTRL_PIN(242, "URTS2"),
		"G18", "mt7623",
		MTK_EINT_FUNCTION(0, 128),
		MTK_FUNCTION(0, "GPIO242"),
		MTK_FUNCTION(1, "URTS2"),
		MTK_FUNCTION(2, "UTXD3"),
		MTK_FUNCTION(3, "URXD3"),
		MTK_FUNCTION(4, "SCL1")
	),
	MTK_PIN(
		PINCTRL_PIN(243, "UCTS2"),
		"H19", "mt7623",
		MTK_EINT_FUNCTION(0, 129),
		MTK_FUNCTION(0, "GPIO243"),
		MTK_FUNCTION(1, "UCTS2"),
		MTK_FUNCTION(2, "URXD3"),
		MTK_FUNCTION(3, "UTXD3"),
		MTK_FUNCTION(4, "SDA1")
	),
	MTK_PIN(
		PINCTRL_PIN(244, "GPIO244"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO244")
	),
	MTK_PIN(
		PINCTRL_PIN(245, "GPIO245"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO245")
	),
	MTK_PIN(
		PINCTRL_PIN(246, "GPIO246"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO246")
	),
	MTK_PIN(
		PINCTRL_PIN(247, "GPIO247"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO247")
	),
	MTK_PIN(
		PINCTRL_PIN(248, "GPIO248"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO248")
	),
	MTK_PIN(
		PINCTRL_PIN(249, "GPIO249"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO249")
	),
	MTK_PIN(
		PINCTRL_PIN(250, "GPIO250"),
		"A15", "mt7623",
		MTK_EINT_FUNCTION(0, 135),
		MTK_FUNCTION(0, "GPIO250"),
		MTK_FUNCTION(1, "TEST_MD7"),
		MTK_FUNCTION(6, "PCIE0_CLKREQ_N")
	),
	MTK_PIN(
		PINCTRL_PIN(251, "GPIO251"),
		"B15", "mt7623",
		MTK_EINT_FUNCTION(0, 136),
		MTK_FUNCTION(0, "GPIO251"),
		MTK_FUNCTION(1, "TEST_MD6"),
		MTK_FUNCTION(6, "PCIE0_WAKE_N")
	),
	MTK_PIN(
		PINCTRL_PIN(252, "GPIO252"),
		"C16", "mt7623",
		MTK_EINT_FUNCTION(0, 137),
		MTK_FUNCTION(0, "GPIO252"),
		MTK_FUNCTION(1, "TEST_MD5"),
		MTK_FUNCTION(6, "PCIE1_CLKREQ_N")
	),
	MTK_PIN(
		PINCTRL_PIN(253, "GPIO253"),
		"D17", "mt7623",
		MTK_EINT_FUNCTION(0, 138),
		MTK_FUNCTION(0, "GPIO253"),
		MTK_FUNCTION(1, "TEST_MD4"),
		MTK_FUNCTION(6, "PCIE1_WAKE_N")
	),
	MTK_PIN(
		PINCTRL_PIN(254, "GPIO254"),
		"D16", "mt7623",
		MTK_EINT_FUNCTION(0, 139),
		MTK_FUNCTION(0, "GPIO254"),
		MTK_FUNCTION(1, "TEST_MD3"),
		MTK_FUNCTION(6, "PCIE2_CLKREQ_N")
	),
	MTK_PIN(
		PINCTRL_PIN(255, "GPIO255"),
		"C17", "mt7623",
		MTK_EINT_FUNCTION(0, 140),
		MTK_FUNCTION(0, "GPIO255"),
		MTK_FUNCTION(1, "TEST_MD2"),
		MTK_FUNCTION(6, "PCIE2_WAKE_N")
	),
	MTK_PIN(
		PINCTRL_PIN(256, "GPIO256"),
		"B17", "mt7623",
		MTK_EINT_FUNCTION(0, 141),
		MTK_FUNCTION(0, "GPIO256"),
		MTK_FUNCTION(1, "TEST_MD1")
	),
	MTK_PIN(
		PINCTRL_PIN(257, "GPIO257"),
		"C15", "mt7623",
		MTK_EINT_FUNCTION(0, 142),
		MTK_FUNCTION(0, "GPIO257"),
		MTK_FUNCTION(1, "TEST_MD0")
	),
	MTK_PIN(
		PINCTRL_PIN(258, "GPIO258"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO258")
	),
	MTK_PIN(
		PINCTRL_PIN(259, "GPIO259"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO259")
	),
	MTK_PIN(
		PINCTRL_PIN(260, "GPIO260"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO260")
	),
	MTK_PIN(
		PINCTRL_PIN(261, "MSDC1_INS"),
		"AD1", "mt7623",
		MTK_EINT_FUNCTION(0, 146),
		MTK_FUNCTION(0, "GPIO261"),
		MTK_FUNCTION(1, "MSDC1_INS")
	),
	MTK_PIN(
		PINCTRL_PIN(262, "G2_TXEN"),
		"A23", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO262"),
		MTK_FUNCTION(1, "G2_TXEN")
	),
	MTK_PIN(
		PINCTRL_PIN(263, "G2_TXD3"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO263"),
		MTK_FUNCTION(1, "G2_TXD3")
	),
	MTK_PIN(
		PINCTRL_PIN(264, "G2_TXD2"),
		"C24", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO264"),
		MTK_FUNCTION(1, "G2_TXD2")
	),
	MTK_PIN(
		PINCTRL_PIN(265, "G2_TXD1"),
		"B25", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO265"),
		MTK_FUNCTION(1, "G2_TXD1")
	),
	MTK_PIN(
		PINCTRL_PIN(266, "G2_TXD0"),
		"A24", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO266"),
		MTK_FUNCTION(1, "G2_TXD0")
	),
	MTK_PIN(
		PINCTRL_PIN(267, "G2_TXCLK"),
		"C23", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO267"),
		MTK_FUNCTION(1, "G2_TXC")
	),
	MTK_PIN(
		PINCTRL_PIN(268, "G2_RXCLK"),
		"B23", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO268"),
		MTK_FUNCTION(1, "G2_RXC")
	),
	MTK_PIN(
		PINCTRL_PIN(269, "G2_RXD0"),
		"D21", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO269"),
		MTK_FUNCTION(1, "G2_RXD0")
	),
	MTK_PIN(
		PINCTRL_PIN(270, "G2_RXD1"),
		"B22", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO270"),
		MTK_FUNCTION(1, "G2_RXD1")
	),
	MTK_PIN(
		PINCTRL_PIN(271, "G2_RXD2"),
		"A22", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO271"),
		MTK_FUNCTION(1, "G2_RXD2")
	),
	MTK_PIN(
		PINCTRL_PIN(272, "G2_RXD3"),
		"C22", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO272"),
		MTK_FUNCTION(1, "G2_RXD3")
	),
	MTK_PIN(
		PINCTRL_PIN(273, "GPIO273"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO273")
	),
	MTK_PIN(
		PINCTRL_PIN(274, "G2_RXDV"),
		"C21", "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO274"),
		MTK_FUNCTION(1, "G2_RXDV")
	),
	MTK_PIN(
		PINCTRL_PIN(275, "G2_MDC"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO275"),
		MTK_FUNCTION(1, "MDC")
	),
	MTK_PIN(
		PINCTRL_PIN(276, "G2_MDIO"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO276"),
		MTK_FUNCTION(1, "MDIO")
	),
	MTK_PIN(
		PINCTRL_PIN(277, "GPIO277"),
		NULL, "mt7623",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO277")
	),
	MTK_PIN(
		PINCTRL_PIN(278, "JTAG_RESET"),
		"H20", "mt7623",
		MTK_EINT_FUNCTION(0, 147),
		MTK_FUNCTION(0, "GPIO278"),
		MTK_FUNCTION(1, "JTAG_RESET")
	),
};

#endif /* __PINCTRL_MTK_MT7623_H */
